<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetEstimate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v1
     * - SOAPHeaderTypes: RequestContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEstimateRequestContainer $freightGetEstimateRequest
     * @return GetEstimateResponseContainer|bool
     */
    public function GetEstimate(GetEstimateRequestContainer $freightGetEstimateRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEstimate($freightGetEstimateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return GetEstimateResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
