<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCardInformation
 * @subpackage Structs
 */
class CreditCardInformation extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ExpiryMonth
     * @var int
     */
    public $ExpiryMonth;
    /**
     * The ExpiryYear
     * @var int
     */
    public $ExpiryYear;
    /**
     * The CVV
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CVV;
    /**
     * Constructor method for CreditCardInformation
     * @uses CreditCardInformation::setType()
     * @uses CreditCardInformation::setNumber()
     * @uses CreditCardInformation::setName()
     * @uses CreditCardInformation::setExpiryMonth()
     * @uses CreditCardInformation::setExpiryYear()
     * @uses CreditCardInformation::setCVV()
     * @param string $type
     * @param string $number
     * @param string $name
     * @param int $expiryMonth
     * @param int $expiryYear
     * @param string $cVV
     */
    public function __construct($type = null, $number = null, $name = null, $expiryMonth = null, $expiryYear = null, $cVV = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setName($name)
            ->setExpiryMonth($expiryMonth)
            ->setExpiryYear($expiryYear)
            ->setCVV($cVV);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses CreditCardType::valueIsValid()
     * @uses CreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return CreditCardInformation
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return CreditCardInformation
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return CreditCardInformation
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ExpiryMonth value
     * @return int|null
     */
    public function getExpiryMonth()
    {
        return $this->ExpiryMonth;
    }
    /**
     * Set ExpiryMonth value
     * @param int $expiryMonth
     * @return CreditCardInformation
     */
    public function setExpiryMonth($expiryMonth = null)
    {
        $this->ExpiryMonth = $expiryMonth;
        return $this;
    }
    /**
     * Get ExpiryYear value
     * @return int|null
     */
    public function getExpiryYear()
    {
        return $this->ExpiryYear;
    }
    /**
     * Set ExpiryYear value
     * @param int $expiryYear
     * @return CreditCardInformation
     */
    public function setExpiryYear($expiryYear = null)
    {
        $this->ExpiryYear = $expiryYear;
        return $this;
    }
    /**
     * Get CVV value
     * @return string|null
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return CreditCardInformation
     */
    public function setCVV($cVV = null)
    {
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return CreditCardInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
