<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInformationalMessage ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfInformationalMessage
 * @subpackage Arrays
 */
class ArrayOfInformationalMessage extends AbstractStructArrayBase
{
    /**
     * The InformationalMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var InformationalMessage[]
     */
    public $InformationalMessage;
    /**
     * Constructor method for ArrayOfInformationalMessage
     * @uses ArrayOfInformationalMessage::setInformationalMessage()
     * @param InformationalMessage[] $informationalMessage
     */
    public function __construct(array $informationalMessage = array())
    {
        $this
            ->setInformationalMessage($informationalMessage);
    }
    /**
     * Get InformationalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return InformationalMessage[]|null
     */
    public function getInformationalMessage()
    {
        return isset($this->InformationalMessage) ? $this->InformationalMessage : null;
    }
    /**
     * Set InformationalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param InformationalMessage[] $informationalMessage
     * @return ArrayOfInformationalMessage
     */
    public function setInformationalMessage(array $informationalMessage = array())
    {
        if (is_null($informationalMessage) || (is_array($informationalMessage) && empty($informationalMessage))) {
            unset($this->InformationalMessage);
        } else {
            $this->InformationalMessage = $informationalMessage;
        }
        return $this;
    }
    /**
     * Add item to InformationalMessage value
     * @throws \InvalidArgumentException
     * @param InformationalMessage $item
     * @return ArrayOfInformationalMessage
     */
    public function addToInformationalMessage(InformationalMessage $item)
    {
        $this->InformationalMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return InformationalMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return InformationalMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return InformationalMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return InformationalMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return InformationalMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InformationalMessage
     */
    public function getAttributeName()
    {
        return 'InformationalMessage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfInformationalMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
