<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Department;
    /**
     * The StreetNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StreetNumber;
    /**
     * The StreetSuffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetSuffix;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * The StreetType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetType;
    /**
     * The StreetDirection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetDirection;
    /**
     * The Suite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suite;
    /**
     * The Floor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Floor;
    /**
     * The StreetAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress2;
    /**
     * The StreetAddress3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress3;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Province
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Province;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var PhoneNumber
     */
    public $PhoneNumber;
    /**
     * The FaxNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var PhoneNumber
     */
    public $FaxNumber;
    /**
     * Constructor method for Address
     * @uses Address::setName()
     * @uses Address::setCompany()
     * @uses Address::setDepartment()
     * @uses Address::setStreetNumber()
     * @uses Address::setStreetSuffix()
     * @uses Address::setStreetName()
     * @uses Address::setStreetType()
     * @uses Address::setStreetDirection()
     * @uses Address::setSuite()
     * @uses Address::setFloor()
     * @uses Address::setStreetAddress2()
     * @uses Address::setStreetAddress3()
     * @uses Address::setCity()
     * @uses Address::setProvince()
     * @uses Address::setCountry()
     * @uses Address::setPostalCode()
     * @uses Address::setPhoneNumber()
     * @uses Address::setFaxNumber()
     * @param string $name
     * @param string $company
     * @param string $department
     * @param string $streetNumber
     * @param string $streetSuffix
     * @param string $streetName
     * @param string $streetType
     * @param string $streetDirection
     * @param string $suite
     * @param string $floor
     * @param string $streetAddress2
     * @param string $streetAddress3
     * @param string $city
     * @param string $province
     * @param string $country
     * @param string $postalCode
     * @param PhoneNumber $phoneNumber
     * @param PhoneNumber $faxNumber
     */
    public function __construct($name = null, $company = null, $department = null, $streetNumber = null, $streetSuffix = null, $streetName = null, $streetType = null, $streetDirection = null, $suite = null, $floor = null, $streetAddress2 = null, $streetAddress3 = null, $city = null, $province = null, $country = null, $postalCode = null, PhoneNumber $phoneNumber = null, PhoneNumber $faxNumber = null)
    {
        $this
            ->setName($name)
            ->setCompany($company)
            ->setDepartment($department)
            ->setStreetNumber($streetNumber)
            ->setStreetSuffix($streetSuffix)
            ->setStreetName($streetName)
            ->setStreetType($streetType)
            ->setStreetDirection($streetDirection)
            ->setSuite($suite)
            ->setFloor($floor)
            ->setStreetAddress2($streetAddress2)
            ->setStreetAddress3($streetAddress3)
            ->setCity($city)
            ->setProvince($province)
            ->setCountry($country)
            ->setPostalCode($postalCode)
            ->setPhoneNumber($phoneNumber)
            ->setFaxNumber($faxNumber);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return Address
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return Address
     */
    public function setCompany($company = null)
    {
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get Department value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartment()
    {
        return isset($this->Department) ? $this->Department : null;
    }
    /**
     * Set Department value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $department
     * @return Address
     */
    public function setDepartment($department = null)
    {
        if (is_null($department) || (is_array($department) && empty($department))) {
            unset($this->Department);
        } else {
            $this->Department = $department;
        }
        return $this;
    }
    /**
     * Get StreetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param string $streetNumber
     * @return Address
     */
    public function setStreetNumber($streetNumber = null)
    {
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get StreetSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetSuffix()
    {
        return isset($this->StreetSuffix) ? $this->StreetSuffix : null;
    }
    /**
     * Set StreetSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetSuffix
     * @return Address
     */
    public function setStreetSuffix($streetSuffix = null)
    {
        if (is_null($streetSuffix) || (is_array($streetSuffix) && empty($streetSuffix))) {
            unset($this->StreetSuffix);
        } else {
            $this->StreetSuffix = $streetSuffix;
        }
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return Address
     */
    public function setStreetName($streetName = null)
    {
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetType()
    {
        return isset($this->StreetType) ? $this->StreetType : null;
    }
    /**
     * Set StreetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetType
     * @return Address
     */
    public function setStreetType($streetType = null)
    {
        if (is_null($streetType) || (is_array($streetType) && empty($streetType))) {
            unset($this->StreetType);
        } else {
            $this->StreetType = $streetType;
        }
        return $this;
    }
    /**
     * Get StreetDirection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetDirection()
    {
        return isset($this->StreetDirection) ? $this->StreetDirection : null;
    }
    /**
     * Set StreetDirection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetDirection
     * @return Address
     */
    public function setStreetDirection($streetDirection = null)
    {
        if (is_null($streetDirection) || (is_array($streetDirection) && empty($streetDirection))) {
            unset($this->StreetDirection);
        } else {
            $this->StreetDirection = $streetDirection;
        }
        return $this;
    }
    /**
     * Get Suite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuite()
    {
        return isset($this->Suite) ? $this->Suite : null;
    }
    /**
     * Set Suite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suite
     * @return Address
     */
    public function setSuite($suite = null)
    {
        if (is_null($suite) || (is_array($suite) && empty($suite))) {
            unset($this->Suite);
        } else {
            $this->Suite = $suite;
        }
        return $this;
    }
    /**
     * Get Floor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFloor()
    {
        return isset($this->Floor) ? $this->Floor : null;
    }
    /**
     * Set Floor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $floor
     * @return Address
     */
    public function setFloor($floor = null)
    {
        if (is_null($floor) || (is_array($floor) && empty($floor))) {
            unset($this->Floor);
        } else {
            $this->Floor = $floor;
        }
        return $this;
    }
    /**
     * Get StreetAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress2()
    {
        return isset($this->StreetAddress2) ? $this->StreetAddress2 : null;
    }
    /**
     * Set StreetAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress2
     * @return Address
     */
    public function setStreetAddress2($streetAddress2 = null)
    {
        if (is_null($streetAddress2) || (is_array($streetAddress2) && empty($streetAddress2))) {
            unset($this->StreetAddress2);
        } else {
            $this->StreetAddress2 = $streetAddress2;
        }
        return $this;
    }
    /**
     * Get StreetAddress3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress3()
    {
        return isset($this->StreetAddress3) ? $this->StreetAddress3 : null;
    }
    /**
     * Set StreetAddress3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress3
     * @return Address
     */
    public function setStreetAddress3($streetAddress3 = null)
    {
        if (is_null($streetAddress3) || (is_array($streetAddress3) && empty($streetAddress3))) {
            unset($this->StreetAddress3);
        } else {
            $this->StreetAddress3 = $streetAddress3;
        }
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return Address
     */
    public function setCity($city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get Province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->Province;
    }
    /**
     * Set Province value
     * @param string $province
     * @return Address
     */
    public function setProvince($province = null)
    {
        $this->Province = $province;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return Address
     */
    public function setCountry($country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return Address
     */
    public function setPostalCode($postalCode = null)
    {
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return PhoneNumber|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param PhoneNumber $phoneNumber
     * @return Address
     */
    public function setPhoneNumber(PhoneNumber $phoneNumber = null)
    {
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get FaxNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return PhoneNumber|null
     */
    public function getFaxNumber()
    {
        return isset($this->FaxNumber) ? $this->FaxNumber : null;
    }
    /**
     * Set FaxNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param PhoneNumber $faxNumber
     * @return Address
     */
    public function setFaxNumber(PhoneNumber $faxNumber = null)
    {
        if (is_null($faxNumber) || (is_array($faxNumber) && empty($faxNumber))) {
            unset($this->FaxNumber);
        } else {
            $this->FaxNumber = $faxNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
