<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Shipment
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The SenderInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\SenderInformation
     */
    public $SenderInformation;
    /**
     * The ReceiverInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReceiverInformation
     */
    public $ReceiverInformation;
    /**
     * The PaymentInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\PaymentInformation
     */
    public $PaymentInformation;
    /**
     * The ShipmentDetails
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\EstimateInformation
     */
    public $ShipmentDetails;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setSenderInformation()
     * @uses Shipment::setReceiverInformation()
     * @uses Shipment::setPaymentInformation()
     * @uses Shipment::setShipmentDetails()
     * @param \StructType\SenderInformation $senderInformation
     * @param \StructType\ReceiverInformation $receiverInformation
     * @param \StructType\PaymentInformation $paymentInformation
     * @param \StructType\EstimateInformation $shipmentDetails
     */
    public function __construct(\StructType\SenderInformation $senderInformation = null, \StructType\ReceiverInformation $receiverInformation = null, \StructType\PaymentInformation $paymentInformation = null, \StructType\EstimateInformation $shipmentDetails = null)
    {
        $this
            ->setSenderInformation($senderInformation)
            ->setReceiverInformation($receiverInformation)
            ->setPaymentInformation($paymentInformation)
            ->setShipmentDetails($shipmentDetails);
    }
    /**
     * Get SenderInformation value
     * @return \StructType\SenderInformation|null
     */
    public function getSenderInformation()
    {
        return $this->SenderInformation;
    }
    /**
     * Set SenderInformation value
     * @param \StructType\SenderInformation $senderInformation
     * @return \StructType\Shipment
     */
    public function setSenderInformation(\StructType\SenderInformation $senderInformation = null)
    {
        $this->SenderInformation = $senderInformation;
        return $this;
    }
    /**
     * Get ReceiverInformation value
     * @return \StructType\ReceiverInformation|null
     */
    public function getReceiverInformation()
    {
        return $this->ReceiverInformation;
    }
    /**
     * Set ReceiverInformation value
     * @param \StructType\ReceiverInformation $receiverInformation
     * @return \StructType\Shipment
     */
    public function setReceiverInformation(\StructType\ReceiverInformation $receiverInformation = null)
    {
        $this->ReceiverInformation = $receiverInformation;
        return $this;
    }
    /**
     * Get PaymentInformation value
     * @return \StructType\PaymentInformation|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * Set PaymentInformation value
     * @param \StructType\PaymentInformation $paymentInformation
     * @return \StructType\Shipment
     */
    public function setPaymentInformation(\StructType\PaymentInformation $paymentInformation = null)
    {
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Get ShipmentDetails value
     * @return \StructType\EstimateInformation|null
     */
    public function getShipmentDetails()
    {
        return $this->ShipmentDetails;
    }
    /**
     * Set ShipmentDetails value
     * @param \StructType\EstimateInformation $shipmentDetails
     * @return \StructType\Shipment
     */
    public function setShipmentDetails(\StructType\EstimateInformation $shipmentDetails = null)
    {
        $this->ShipmentDetails = $shipmentDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
