<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItem StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LineItem
 * @subpackage Structs
 */
class LineItem extends AbstractStructBase
{
    /**
     * The LineNumber
     * @var int
     */
    public $LineNumber;
    /**
     * The Pieces
     * @var int
     */
    public $Pieces;
    /**
     * The HandlingUnit
     * @var int
     */
    public $HandlingUnit;
    /**
     * The HandlingUnitType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $HandlingUnitType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Weight
     */
    public $Weight;
    /**
     * The FreightClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FreightClass;
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dimension
     */
    public $Length;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dimension
     */
    public $Width;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dimension
     */
    public $Height;
    /**
     * The BasePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BasePrice;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Charge;
    /**
     * Constructor method for LineItem
     * @uses LineItem::setLineNumber()
     * @uses LineItem::setPieces()
     * @uses LineItem::setHandlingUnit()
     * @uses LineItem::setHandlingUnitType()
     * @uses LineItem::setDescription()
     * @uses LineItem::setWeight()
     * @uses LineItem::setFreightClass()
     * @uses LineItem::setLength()
     * @uses LineItem::setWidth()
     * @uses LineItem::setHeight()
     * @uses LineItem::setBasePrice()
     * @uses LineItem::setCharge()
     * @param int $lineNumber
     * @param int $pieces
     * @param int $handlingUnit
     * @param string $handlingUnitType
     * @param string $description
     * @param \StructType\Weight $weight
     * @param string $freightClass
     * @param \StructType\Dimension $length
     * @param \StructType\Dimension $width
     * @param \StructType\Dimension $height
     * @param float $basePrice
     * @param float $charge
     */
    public function __construct($lineNumber = null, $pieces = null, $handlingUnit = null, $handlingUnitType = null, $description = null, \StructType\Weight $weight = null, $freightClass = null, \StructType\Dimension $length = null, \StructType\Dimension $width = null, \StructType\Dimension $height = null, $basePrice = null, $charge = null)
    {
        $this
            ->setLineNumber($lineNumber)
            ->setPieces($pieces)
            ->setHandlingUnit($handlingUnit)
            ->setHandlingUnitType($handlingUnitType)
            ->setDescription($description)
            ->setWeight($weight)
            ->setFreightClass($freightClass)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setBasePrice($basePrice)
            ->setCharge($charge);
    }
    /**
     * Get LineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \StructType\LineItem
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !is_numeric($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get Pieces value
     * @return int|null
     */
    public function getPieces()
    {
        return $this->Pieces;
    }
    /**
     * Set Pieces value
     * @param int $pieces
     * @return \StructType\LineItem
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: int
        if (!is_null($pieces) && !is_numeric($pieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pieces)), __LINE__);
        }
        $this->Pieces = $pieces;
        return $this;
    }
    /**
     * Get HandlingUnit value
     * @return int|null
     */
    public function getHandlingUnit()
    {
        return $this->HandlingUnit;
    }
    /**
     * Set HandlingUnit value
     * @param int $handlingUnit
     * @return \StructType\LineItem
     */
    public function setHandlingUnit($handlingUnit = null)
    {
        // validation for constraint: int
        if (!is_null($handlingUnit) && !is_numeric($handlingUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($handlingUnit)), __LINE__);
        }
        $this->HandlingUnit = $handlingUnit;
        return $this;
    }
    /**
     * Get HandlingUnitType value
     * @return string|null
     */
    public function getHandlingUnitType()
    {
        return $this->HandlingUnitType;
    }
    /**
     * Set HandlingUnitType value
     * @param string $handlingUnitType
     * @return \StructType\LineItem
     */
    public function setHandlingUnitType($handlingUnitType = null)
    {
        // validation for constraint: string
        if (!is_null($handlingUnitType) && !is_string($handlingUnitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($handlingUnitType)), __LINE__);
        }
        $this->HandlingUnitType = $handlingUnitType;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\LineItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Weight value
     * @return \StructType\Weight|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \StructType\Weight $weight
     * @return \StructType\LineItem
     */
    public function setWeight(\StructType\Weight $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get FreightClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFreightClass()
    {
        return isset($this->FreightClass) ? $this->FreightClass : null;
    }
    /**
     * Set FreightClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $freightClass
     * @return \StructType\LineItem
     */
    public function setFreightClass($freightClass = null)
    {
        // validation for constraint: string
        if (!is_null($freightClass) && !is_string($freightClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($freightClass)), __LINE__);
        }
        if (is_null($freightClass) || (is_array($freightClass) && empty($freightClass))) {
            unset($this->FreightClass);
        } else {
            $this->FreightClass = $freightClass;
        }
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dimension|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Dimension $length
     * @return \StructType\LineItem
     */
    public function setLength(\StructType\Dimension $length = null)
    {
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dimension|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Dimension $width
     * @return \StructType\LineItem
     */
    public function setWidth(\StructType\Dimension $width = null)
    {
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dimension|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Dimension $height
     * @return \StructType\LineItem
     */
    public function setHeight(\StructType\Dimension $height = null)
    {
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get BasePrice value
     * @return float|null
     */
    public function getBasePrice()
    {
        return $this->BasePrice;
    }
    /**
     * Set BasePrice value
     * @param float $basePrice
     * @return \StructType\LineItem
     */
    public function setBasePrice($basePrice = null)
    {
        $this->BasePrice = $basePrice;
        return $this;
    }
    /**
     * Get Charge value
     * @return float|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param float $charge
     * @return \StructType\LineItem
     */
    public function setCharge($charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
