<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimateInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EstimateInformation
 * @subpackage Structs
 */
class EstimateInformation extends AbstractStructBase
{
    /**
     * The ServiceTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceTypeCode;
    /**
     * The ShipmentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipmentDate;
    /**
     * The DeclaredValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DeclaredValue;
    /**
     * The CODAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CODAmount;
    /**
     * The SpecialInstructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialInstructions;
    /**
     * The LineItemDetails
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLineItem
     */
    public $LineItemDetails;
    /**
     * The AccessorialParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBoolValuePair
     */
    public $AccessorialParameters;
    /**
     * Constructor method for EstimateInformation
     * @uses EstimateInformation::setServiceTypeCode()
     * @uses EstimateInformation::setShipmentDate()
     * @uses EstimateInformation::setDeclaredValue()
     * @uses EstimateInformation::setCODAmount()
     * @uses EstimateInformation::setSpecialInstructions()
     * @uses EstimateInformation::setLineItemDetails()
     * @uses EstimateInformation::setAccessorialParameters()
     * @param string $serviceTypeCode
     * @param string $shipmentDate
     * @param float $declaredValue
     * @param float $cODAmount
     * @param string $specialInstructions
     * @param \ArrayType\ArrayOfLineItem $lineItemDetails
     * @param \ArrayType\ArrayOfBoolValuePair $accessorialParameters
     */
    public function __construct($serviceTypeCode = null, $shipmentDate = null, $declaredValue = null, $cODAmount = null, $specialInstructions = null, \ArrayType\ArrayOfLineItem $lineItemDetails = null, \ArrayType\ArrayOfBoolValuePair $accessorialParameters = null)
    {
        $this
            ->setServiceTypeCode($serviceTypeCode)
            ->setShipmentDate($shipmentDate)
            ->setDeclaredValue($declaredValue)
            ->setCODAmount($cODAmount)
            ->setSpecialInstructions($specialInstructions)
            ->setLineItemDetails($lineItemDetails)
            ->setAccessorialParameters($accessorialParameters);
    }
    /**
     * Get ServiceTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceTypeCode()
    {
        return isset($this->ServiceTypeCode) ? $this->ServiceTypeCode : null;
    }
    /**
     * Set ServiceTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceTypeCode
     * @return \StructType\EstimateInformation
     */
    public function setServiceTypeCode($serviceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceTypeCode) && !is_string($serviceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceTypeCode)), __LINE__);
        }
        if (is_null($serviceTypeCode) || (is_array($serviceTypeCode) && empty($serviceTypeCode))) {
            unset($this->ServiceTypeCode);
        } else {
            $this->ServiceTypeCode = $serviceTypeCode;
        }
        return $this;
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentDate
     * @return \StructType\EstimateInformation
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentDate)), __LINE__);
        }
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Get DeclaredValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDeclaredValue()
    {
        return isset($this->DeclaredValue) ? $this->DeclaredValue : null;
    }
    /**
     * Set DeclaredValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $declaredValue
     * @return \StructType\EstimateInformation
     */
    public function setDeclaredValue($declaredValue = null)
    {
        if (is_null($declaredValue) || (is_array($declaredValue) && empty($declaredValue))) {
            unset($this->DeclaredValue);
        } else {
            $this->DeclaredValue = $declaredValue;
        }
        return $this;
    }
    /**
     * Get CODAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCODAmount()
    {
        return isset($this->CODAmount) ? $this->CODAmount : null;
    }
    /**
     * Set CODAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cODAmount
     * @return \StructType\EstimateInformation
     */
    public function setCODAmount($cODAmount = null)
    {
        if (is_null($cODAmount) || (is_array($cODAmount) && empty($cODAmount))) {
            unset($this->CODAmount);
        } else {
            $this->CODAmount = $cODAmount;
        }
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialInstructions()
    {
        return isset($this->SpecialInstructions) ? $this->SpecialInstructions : null;
    }
    /**
     * Set SpecialInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialInstructions
     * @return \StructType\EstimateInformation
     */
    public function setSpecialInstructions($specialInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions) && !is_string($specialInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialInstructions)), __LINE__);
        }
        if (is_null($specialInstructions) || (is_array($specialInstructions) && empty($specialInstructions))) {
            unset($this->SpecialInstructions);
        } else {
            $this->SpecialInstructions = $specialInstructions;
        }
        return $this;
    }
    /**
     * Get LineItemDetails value
     * @return \ArrayType\ArrayOfLineItem|null
     */
    public function getLineItemDetails()
    {
        return $this->LineItemDetails;
    }
    /**
     * Set LineItemDetails value
     * @param \ArrayType\ArrayOfLineItem $lineItemDetails
     * @return \StructType\EstimateInformation
     */
    public function setLineItemDetails(\ArrayType\ArrayOfLineItem $lineItemDetails = null)
    {
        $this->LineItemDetails = $lineItemDetails;
        return $this;
    }
    /**
     * Get AccessorialParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBoolValuePair|null
     */
    public function getAccessorialParameters()
    {
        return isset($this->AccessorialParameters) ? $this->AccessorialParameters : null;
    }
    /**
     * Set AccessorialParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBoolValuePair $accessorialParameters
     * @return \StructType\EstimateInformation
     */
    public function setAccessorialParameters(\ArrayType\ArrayOfBoolValuePair $accessorialParameters = null)
    {
        if (is_null($accessorialParameters) || (is_array($accessorialParameters) && empty($accessorialParameters))) {
            unset($this->AccessorialParameters);
        } else {
            $this->AccessorialParameters = $accessorialParameters;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimateInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
