<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimension StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Dimension
 * @subpackage Structs
 */
class Dimension extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The DimensionUnit
     * @var string
     */
    public $DimensionUnit;
    /**
     * Constructor method for Dimension
     * @uses Dimension::setValue()
     * @uses Dimension::setDimensionUnit()
     * @param float $value
     * @param string $dimensionUnit
     */
    public function __construct($value = null, $dimensionUnit = null)
    {
        $this
            ->setValue($value)
            ->setDimensionUnit($dimensionUnit);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\Dimension
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get DimensionUnit value
     * @return string|null
     */
    public function getDimensionUnit()
    {
        return $this->DimensionUnit;
    }
    /**
     * Set DimensionUnit value
     * @uses \EnumType\DimensionUnit::valueIsValid()
     * @uses \EnumType\DimensionUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dimensionUnit
     * @return \StructType\Dimension
     */
    public function setDimensionUnit($dimensionUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DimensionUnit::valueIsValid($dimensionUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dimensionUnit, implode(', ', \EnumType\DimensionUnit::getValidValues())), __LINE__);
        }
        $this->DimensionUnit = $dimensionUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Dimension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
