<?php

namespace EnumType;

/**
 * This class stands for Language EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Language
 * @subpackage Enumerations
 */
class Language
{
    /**
     * Constant for value 'en'
     * @return string 'en'
     */
    const VALUE_EN = 'en';
    /**
     * Constant for value 'fr'
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EN
     * @uses self::VALUE_FR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EN,
            self::VALUE_FR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
