<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInformationalMessage ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfInformationalMessage
 * @subpackage Arrays
 */
class ArrayOfInformationalMessage extends AbstractStructArrayBase
{
    /**
     * The InformationalMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InformationalMessage[]
     */
    public $InformationalMessage;
    /**
     * Constructor method for ArrayOfInformationalMessage
     * @uses ArrayOfInformationalMessage::setInformationalMessage()
     * @param \StructType\InformationalMessage[] $informationalMessage
     */
    public function __construct(array $informationalMessage = array())
    {
        $this
            ->setInformationalMessage($informationalMessage);
    }
    /**
     * Get InformationalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InformationalMessage[]|null
     */
    public function getInformationalMessage()
    {
        return isset($this->InformationalMessage) ? $this->InformationalMessage : null;
    }
    /**
     * Set InformationalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InformationalMessage[] $informationalMessage
     * @return \ArrayType\ArrayOfInformationalMessage
     */
    public function setInformationalMessage(array $informationalMessage = array())
    {
        foreach ($informationalMessage as $arrayOfInformationalMessageInformationalMessageItem) {
            // validation for constraint: itemType
            if (!$arrayOfInformationalMessageInformationalMessageItem instanceof \StructType\InformationalMessage) {
                throw new \InvalidArgumentException(sprintf('The InformationalMessage property can only contain items of \StructType\InformationalMessage, "%s" given', is_object($arrayOfInformationalMessageInformationalMessageItem) ? get_class($arrayOfInformationalMessageInformationalMessageItem) : gettype($arrayOfInformationalMessageInformationalMessageItem)), __LINE__);
            }
        }
        if (is_null($informationalMessage) || (is_array($informationalMessage) && empty($informationalMessage))) {
            unset($this->InformationalMessage);
        } else {
            $this->InformationalMessage = $informationalMessage;
        }
        return $this;
    }
    /**
     * Add item to InformationalMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\InformationalMessage $item
     * @return \ArrayType\ArrayOfInformationalMessage
     */
    public function addToInformationalMessage(\StructType\InformationalMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InformationalMessage) {
            throw new \InvalidArgumentException(sprintf('The InformationalMessage property can only contain items of \StructType\InformationalMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InformationalMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InformationalMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InformationalMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InformationalMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InformationalMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InformationalMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InformationalMessage
     */
    public function getAttributeName()
    {
        return 'InformationalMessage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInformationalMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
