<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Weight StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Weight
 * @subpackage Structs
 */
class Weight extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The WeightUnit
     * @var string
     */
    public $WeightUnit;
    /**
     * Constructor method for Weight
     * @uses Weight::setValue()
     * @uses Weight::setWeightUnit()
     * @param float $value
     * @param string $weightUnit
     */
    public function __construct($value = null, $weightUnit = null)
    {
        $this
            ->setValue($value)
            ->setWeightUnit($weightUnit);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\Weight
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get WeightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->WeightUnit;
    }
    /**
     * Set WeightUnit value
     * @uses \EnumType\WeightUnit::valueIsValid()
     * @uses \EnumType\WeightUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weightUnit
     * @return \StructType\Weight
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WeightUnit::valueIsValid($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $weightUnit, implode(', ', \EnumType\WeightUnit::getValidValues())), __LINE__);
        }
        $this->WeightUnit = $weightUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Weight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
