<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SenderInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SenderInformation
 * @subpackage Structs
 */
class SenderInformation extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * Constructor method for SenderInformation
     * @uses SenderInformation::setAddress()
     * @uses SenderInformation::setEmailAddress()
     * @param \StructType\Address $address
     * @param string $emailAddress
     */
    public function __construct(\StructType\Address $address = null, $emailAddress = null)
    {
        $this
            ->setAddress($address)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\SenderInformation
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\SenderInformation
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SenderInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
