<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestContext StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestContext
 * @subpackage Structs
 */
class RequestContext extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The GroupID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GroupID;
    /**
     * The RequestReference
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RequestReference;
    /**
     * The UserToken
     * Meta informations extracted from the WSDL
     * - documentation: UserToken - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserToken;
    /**
     * Constructor method for RequestContext
     * @uses RequestContext::setVersion()
     * @uses RequestContext::setLanguage()
     * @uses RequestContext::setGroupID()
     * @uses RequestContext::setRequestReference()
     * @uses RequestContext::setUserToken()
     * @param string $version
     * @param string $language
     * @param string $groupID
     * @param string $requestReference
     * @param string $userToken
     */
    public function __construct($version = null, $language = null, $groupID = null, $requestReference = null, $userToken = null)
    {
        $this
            ->setVersion($version)
            ->setLanguage($language)
            ->setGroupID($groupID)
            ->setRequestReference($requestReference)
            ->setUserToken($userToken);
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\RequestContext
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\RequestContext
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $language, implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get GroupID value
     * @return string|null
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param string $groupID
     * @return \StructType\RequestContext
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: string
        if (!is_null($groupID) && !is_string($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get RequestReference value
     * @return string|null
     */
    public function getRequestReference()
    {
        return $this->RequestReference;
    }
    /**
     * Set RequestReference value
     * @param string $requestReference
     * @return \StructType\RequestContext
     */
    public function setRequestReference($requestReference = null)
    {
        // validation for constraint: string
        if (!is_null($requestReference) && !is_string($requestReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestReference)), __LINE__);
        }
        $this->RequestReference = $requestReference;
        return $this;
    }
    /**
     * Get UserToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserToken()
    {
        return isset($this->UserToken) ? $this->UserToken : null;
    }
    /**
     * Set UserToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userToken
     * @return \StructType\RequestContext
     */
    public function setUserToken($userToken = null)
    {
        // validation for constraint: string
        if (!is_null($userToken) && !is_string($userToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userToken)), __LINE__);
        }
        if (is_null($userToken) || (is_array($userToken) && empty($userToken))) {
            unset($this->UserToken);
        } else {
            $this->UserToken = $userToken;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
