<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentInformation
 * @subpackage Structs
 */
class PaymentInformation extends AbstractStructBase
{
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The RegisteredAccountNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RegisteredAccountNumber;
    /**
     * The BillingAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingAccountNumber;
    /**
     * The CreditCardInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditCardInformation
     */
    public $CreditCardInformation;
    /**
     * Constructor method for PaymentInformation
     * @uses PaymentInformation::setPaymentType()
     * @uses PaymentInformation::setRegisteredAccountNumber()
     * @uses PaymentInformation::setBillingAccountNumber()
     * @uses PaymentInformation::setCreditCardInformation()
     * @param string $paymentType
     * @param string $registeredAccountNumber
     * @param string $billingAccountNumber
     * @param \StructType\CreditCardInformation $creditCardInformation
     */
    public function __construct($paymentType = null, $registeredAccountNumber = null, $billingAccountNumber = null, \StructType\CreditCardInformation $creditCardInformation = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setRegisteredAccountNumber($registeredAccountNumber)
            ->setBillingAccountNumber($billingAccountNumber)
            ->setCreditCardInformation($creditCardInformation);
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \EnumType\PaymentType::valueIsValid()
     * @uses \EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \StructType\PaymentInformation
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentType, implode(', ', \EnumType\PaymentType::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get RegisteredAccountNumber value
     * @return string|null
     */
    public function getRegisteredAccountNumber()
    {
        return $this->RegisteredAccountNumber;
    }
    /**
     * Set RegisteredAccountNumber value
     * @param string $registeredAccountNumber
     * @return \StructType\PaymentInformation
     */
    public function setRegisteredAccountNumber($registeredAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($registeredAccountNumber) && !is_string($registeredAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registeredAccountNumber)), __LINE__);
        }
        $this->RegisteredAccountNumber = $registeredAccountNumber;
        return $this;
    }
    /**
     * Get BillingAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingAccountNumber()
    {
        return isset($this->BillingAccountNumber) ? $this->BillingAccountNumber : null;
    }
    /**
     * Set BillingAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingAccountNumber
     * @return \StructType\PaymentInformation
     */
    public function setBillingAccountNumber($billingAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingAccountNumber) && !is_string($billingAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAccountNumber)), __LINE__);
        }
        if (is_null($billingAccountNumber) || (is_array($billingAccountNumber) && empty($billingAccountNumber))) {
            unset($this->BillingAccountNumber);
        } else {
            $this->BillingAccountNumber = $billingAccountNumber;
        }
        return $this;
    }
    /**
     * Get CreditCardInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditCardInformation|null
     */
    public function getCreditCardInformation()
    {
        return isset($this->CreditCardInformation) ? $this->CreditCardInformation : null;
    }
    /**
     * Set CreditCardInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreditCardInformation $creditCardInformation
     * @return \StructType\PaymentInformation
     */
    public function setCreditCardInformation(\StructType\CreditCardInformation $creditCardInformation = null)
    {
        if (is_null($creditCardInformation) || (is_array($creditCardInformation) && empty($creditCardInformation))) {
            unset($this->CreditCardInformation);
        } else {
            $this->CreditCardInformation = $creditCardInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
