<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoolValuePair StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BoolValuePair
 * @subpackage Structs
 */
class BoolValuePair extends AbstractStructBase
{
    /**
     * The Keyword
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Keyword;
    /**
     * The Value
     * @var bool
     */
    public $Value;
    /**
     * Constructor method for BoolValuePair
     * @uses BoolValuePair::setKeyword()
     * @uses BoolValuePair::setValue()
     * @param string $keyword
     * @param bool $value
     */
    public function __construct($keyword = null, $value = null)
    {
        $this
            ->setKeyword($keyword)
            ->setValue($value);
    }
    /**
     * Get Keyword value
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param string $keyword
     * @return \StructType\BoolValuePair
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyword)), __LINE__);
        }
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get Value value
     * @return bool|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param bool $value
     * @return \StructType\BoolValuePair
     */
    public function setValue($value = null)
    {
        // validation for constraint: boolean
        if (!is_null($value) && !is_bool($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BoolValuePair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
