<?php

namespace EnumType;

/**
 * This class stands for CreditCardType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCardType
 * @subpackage Enumerations
 */
class CreditCardType
{
    /**
     * Constant for value 'Visa'
     * @return string 'Visa'
     */
    const VALUE_VISA = 'Visa';
    /**
     * Constant for value 'MasterCard'
     * @return string 'MasterCard'
     */
    const VALUE_MASTER_CARD = 'MasterCard';
    /**
     * Constant for value 'AmericanExpress'
     * @return string 'AmericanExpress'
     */
    const VALUE_AMERICAN_EXPRESS = 'AmericanExpress';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VISA
     * @uses self::VALUE_MASTER_CARD
     * @uses self::VALUE_AMERICAN_EXPRESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VISA,
            self::VALUE_MASTER_CARD,
            self::VALUE_AMERICAN_EXPRESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
