<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccessorialItem ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccessorialItem
 * @subpackage Arrays
 */
class ArrayOfAccessorialItem extends AbstractStructArrayBase
{
    /**
     * The AccessorialItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccessorialItem[]
     */
    public $AccessorialItem;
    /**
     * Constructor method for ArrayOfAccessorialItem
     * @uses ArrayOfAccessorialItem::setAccessorialItem()
     * @param \StructType\AccessorialItem[] $accessorialItem
     */
    public function __construct(array $accessorialItem = array())
    {
        $this
            ->setAccessorialItem($accessorialItem);
    }
    /**
     * Get AccessorialItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccessorialItem[]|null
     */
    public function getAccessorialItem()
    {
        return isset($this->AccessorialItem) ? $this->AccessorialItem : null;
    }
    /**
     * Set AccessorialItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccessorialItem[] $accessorialItem
     * @return \ArrayType\ArrayOfAccessorialItem
     */
    public function setAccessorialItem(array $accessorialItem = array())
    {
        foreach ($accessorialItem as $arrayOfAccessorialItemAccessorialItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccessorialItemAccessorialItemItem instanceof \StructType\AccessorialItem) {
                throw new \InvalidArgumentException(sprintf('The AccessorialItem property can only contain items of \StructType\AccessorialItem, "%s" given', is_object($arrayOfAccessorialItemAccessorialItemItem) ? get_class($arrayOfAccessorialItemAccessorialItemItem) : gettype($arrayOfAccessorialItemAccessorialItemItem)), __LINE__);
            }
        }
        if (is_null($accessorialItem) || (is_array($accessorialItem) && empty($accessorialItem))) {
            unset($this->AccessorialItem);
        } else {
            $this->AccessorialItem = $accessorialItem;
        }
        return $this;
    }
    /**
     * Add item to AccessorialItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessorialItem $item
     * @return \ArrayType\ArrayOfAccessorialItem
     */
    public function addToAccessorialItem(\StructType\AccessorialItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessorialItem) {
            throw new \InvalidArgumentException(sprintf('The AccessorialItem property can only contain items of \StructType\AccessorialItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccessorialItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccessorialItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccessorialItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccessorialItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccessorialItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccessorialItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccessorialItem
     */
    public function getAttributeName()
    {
        return 'AccessorialItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAccessorialItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
