<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vergi StructType
 * @subpackage Structs
 */
class Vergi extends AbstractStructBase
{
    /**
     * The matrah
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 18
     * @var float
     */
    public $matrah;
    /**
     * The vergiKodu
     * @var string
     */
    public $vergiKodu;
    /**
     * The vergiTutari
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 18
     * @var float
     */
    public $vergiTutari;
    /**
     * The vergiOrani
     * Meta informations extracted from the WSDL
     * - maxInclusive: 100
     * - minInclusive: 0
     * - totalDigits: 3
     * @var int
     */
    public $vergiOrani;
    /**
     * Constructor method for vergi
     * @uses Vergi::setMatrah()
     * @uses Vergi::setVergiKodu()
     * @uses Vergi::setVergiTutari()
     * @uses Vergi::setVergiOrani()
     * @param float $matrah
     * @param string $vergiKodu
     * @param float $vergiTutari
     * @param int $vergiOrani
     */
    public function __construct($matrah = null, $vergiKodu = null, $vergiTutari = null, $vergiOrani = null)
    {
        $this
            ->setMatrah($matrah)
            ->setVergiKodu($vergiKodu)
            ->setVergiTutari($vergiTutari)
            ->setVergiOrani($vergiOrani);
    }
    /**
     * Get matrah value
     * @return float|null
     */
    public function getMatrah()
    {
        return $this->matrah;
    }
    /**
     * Set matrah value
     * @param float $matrah
     * @return \StructType\Vergi
     */
    public function setMatrah($matrah = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($matrah) && strlen(substr($matrah, strpos($matrah, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($matrah, strpos($matrah, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($matrah) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $matrah)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($matrah, strpos($matrah, '.')))), __LINE__);
        }
        $this->matrah = $matrah;
        return $this;
    }
    /**
     * Get vergiKodu value
     * @return string|null
     */
    public function getVergiKodu()
    {
        return $this->vergiKodu;
    }
    /**
     * Set vergiKodu value
     * @uses \EnumType\VergiKodu::valueIsValid()
     * @uses \EnumType\VergiKodu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vergiKodu
     * @return \StructType\Vergi
     */
    public function setVergiKodu($vergiKodu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VergiKodu::valueIsValid($vergiKodu)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vergiKodu, implode(', ', \EnumType\VergiKodu::getValidValues())), __LINE__);
        }
        $this->vergiKodu = $vergiKodu;
        return $this;
    }
    /**
     * Get vergiTutari value
     * @return float|null
     */
    public function getVergiTutari()
    {
        return $this->vergiTutari;
    }
    /**
     * Set vergiTutari value
     * @param float $vergiTutari
     * @return \StructType\Vergi
     */
    public function setVergiTutari($vergiTutari = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($vergiTutari) && strlen(substr($vergiTutari, strpos($vergiTutari, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($vergiTutari, strpos($vergiTutari, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($vergiTutari) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $vergiTutari)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($vergiTutari, strpos($vergiTutari, '.')))), __LINE__);
        }
        $this->vergiTutari = $vergiTutari;
        return $this;
    }
    /**
     * Get vergiOrani value
     * @return int|null
     */
    public function getVergiOrani()
    {
        return $this->vergiOrani;
    }
    /**
     * Set vergiOrani value
     * @param int $vergiOrani
     * @return \StructType\Vergi
     */
    public function setVergiOrani($vergiOrani = null)
    {
        // validation for constraint: maxInclusive
        if ($vergiOrani > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 100, "%s" given', $vergiOrani), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($vergiOrani < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $vergiOrani), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($vergiOrani) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $vergiOrani)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 digits, "%d" given', strlen(substr($vergiOrani, strpos($vergiOrani, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($vergiOrani) && !is_numeric($vergiOrani)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vergiOrani)), __LINE__);
        }
        $this->vergiOrani = $vergiOrani;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vergi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
