<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tevkifat StructType
 * @subpackage Structs
 */
class Tevkifat extends AbstractStructBase
{
    /**
     * The tevkifatKodu
     * @var string
     */
    public $tevkifatKodu;
    /**
     * The tevkifatTutari
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 18
     * @var float
     */
    public $tevkifatTutari;
    /**
     * The tevkifatOrani
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - totalDigits: 5
     * @var float
     */
    public $tevkifatOrani;
    /**
     * Constructor method for tevkifat
     * @uses Tevkifat::setTevkifatKodu()
     * @uses Tevkifat::setTevkifatTutari()
     * @uses Tevkifat::setTevkifatOrani()
     * @param string $tevkifatKodu
     * @param float $tevkifatTutari
     * @param float $tevkifatOrani
     */
    public function __construct($tevkifatKodu = null, $tevkifatTutari = null, $tevkifatOrani = null)
    {
        $this
            ->setTevkifatKodu($tevkifatKodu)
            ->setTevkifatTutari($tevkifatTutari)
            ->setTevkifatOrani($tevkifatOrani);
    }
    /**
     * Get tevkifatKodu value
     * @return string|null
     */
    public function getTevkifatKodu()
    {
        return $this->tevkifatKodu;
    }
    /**
     * Set tevkifatKodu value
     * @uses \EnumType\TevkifatKodu::valueIsValid()
     * @uses \EnumType\TevkifatKodu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tevkifatKodu
     * @return \StructType\Tevkifat
     */
    public function setTevkifatKodu($tevkifatKodu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TevkifatKodu::valueIsValid($tevkifatKodu)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tevkifatKodu, implode(', ', \EnumType\TevkifatKodu::getValidValues())), __LINE__);
        }
        $this->tevkifatKodu = $tevkifatKodu;
        return $this;
    }
    /**
     * Get tevkifatTutari value
     * @return float|null
     */
    public function getTevkifatTutari()
    {
        return $this->tevkifatTutari;
    }
    /**
     * Set tevkifatTutari value
     * @param float $tevkifatTutari
     * @return \StructType\Tevkifat
     */
    public function setTevkifatTutari($tevkifatTutari = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($tevkifatTutari) && strlen(substr($tevkifatTutari, strpos($tevkifatTutari, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($tevkifatTutari, strpos($tevkifatTutari, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($tevkifatTutari) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $tevkifatTutari)) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 18 digits, "%d" given', strlen(substr($tevkifatTutari, strpos($tevkifatTutari, '.')))), __LINE__);
        }
        $this->tevkifatTutari = $tevkifatTutari;
        return $this;
    }
    /**
     * Get tevkifatOrani value
     * @return float|null
     */
    public function getTevkifatOrani()
    {
        return $this->tevkifatOrani;
    }
    /**
     * Set tevkifatOrani value
     * @param float $tevkifatOrani
     * @return \StructType\Tevkifat
     */
    public function setTevkifatOrani($tevkifatOrani = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($tevkifatOrani) && strlen(substr($tevkifatOrani, strpos($tevkifatOrani, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($tevkifatOrani, strpos($tevkifatOrani, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($tevkifatOrani > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 100, "%s" given', $tevkifatOrani), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($tevkifatOrani) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $tevkifatOrani)) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 5 digits, "%d" given', strlen(substr($tevkifatOrani, strpos($tevkifatOrani, '.')))), __LINE__);
        }
        $this->tevkifatOrani = $tevkifatOrani;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tevkifat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
