<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignedSignaturePropertiesType StructType
 * @subpackage Structs
 */
class SignedSignaturePropertiesType extends AbstractStructBase
{
    /**
     * The SigningTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SigningTime;
    /**
     * The SigningCertificate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CertIDListType
     */
    public $SigningCertificate;
    /**
     * The SignaturePolicyIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignaturePolicyIdentifierType
     */
    public $SignaturePolicyIdentifier;
    /**
     * The SignatureProductionPlace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignatureProductionPlaceType
     */
    public $SignatureProductionPlace;
    /**
     * The SignerRole
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignerRoleType
     */
    public $SignerRole;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignedSignaturePropertiesType
     * @uses SignedSignaturePropertiesType::setSigningTime()
     * @uses SignedSignaturePropertiesType::setSigningCertificate()
     * @uses SignedSignaturePropertiesType::setSignaturePolicyIdentifier()
     * @uses SignedSignaturePropertiesType::setSignatureProductionPlace()
     * @uses SignedSignaturePropertiesType::setSignerRole()
     * @uses SignedSignaturePropertiesType::setId()
     * @param string $signingTime
     * @param \StructType\CertIDListType $signingCertificate
     * @param \StructType\SignaturePolicyIdentifierType $signaturePolicyIdentifier
     * @param \StructType\SignatureProductionPlaceType $signatureProductionPlace
     * @param \StructType\SignerRoleType $signerRole
     * @param string $id
     */
    public function __construct($signingTime = null, \StructType\CertIDListType $signingCertificate = null, \StructType\SignaturePolicyIdentifierType $signaturePolicyIdentifier = null, \StructType\SignatureProductionPlaceType $signatureProductionPlace = null, \StructType\SignerRoleType $signerRole = null, $id = null)
    {
        $this
            ->setSigningTime($signingTime)
            ->setSigningCertificate($signingCertificate)
            ->setSignaturePolicyIdentifier($signaturePolicyIdentifier)
            ->setSignatureProductionPlace($signatureProductionPlace)
            ->setSignerRole($signerRole)
            ->setId($id);
    }
    /**
     * Get SigningTime value
     * @return string|null
     */
    public function getSigningTime()
    {
        return $this->SigningTime;
    }
    /**
     * Set SigningTime value
     * @param string $signingTime
     * @return \StructType\SignedSignaturePropertiesType
     */
    public function setSigningTime($signingTime = null)
    {
        // validation for constraint: string
        if (!is_null($signingTime) && !is_string($signingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signingTime)), __LINE__);
        }
        $this->SigningTime = $signingTime;
        return $this;
    }
    /**
     * Get SigningCertificate value
     * @return \StructType\CertIDListType|null
     */
    public function getSigningCertificate()
    {
        return $this->SigningCertificate;
    }
    /**
     * Set SigningCertificate value
     * @param \StructType\CertIDListType $signingCertificate
     * @return \StructType\SignedSignaturePropertiesType
     */
    public function setSigningCertificate(\StructType\CertIDListType $signingCertificate = null)
    {
        $this->SigningCertificate = $signingCertificate;
        return $this;
    }
    /**
     * Get SignaturePolicyIdentifier value
     * @return \StructType\SignaturePolicyIdentifierType|null
     */
    public function getSignaturePolicyIdentifier()
    {
        return $this->SignaturePolicyIdentifier;
    }
    /**
     * Set SignaturePolicyIdentifier value
     * @param \StructType\SignaturePolicyIdentifierType $signaturePolicyIdentifier
     * @return \StructType\SignedSignaturePropertiesType
     */
    public function setSignaturePolicyIdentifier(\StructType\SignaturePolicyIdentifierType $signaturePolicyIdentifier = null)
    {
        $this->SignaturePolicyIdentifier = $signaturePolicyIdentifier;
        return $this;
    }
    /**
     * Get SignatureProductionPlace value
     * @return \StructType\SignatureProductionPlaceType|null
     */
    public function getSignatureProductionPlace()
    {
        return $this->SignatureProductionPlace;
    }
    /**
     * Set SignatureProductionPlace value
     * @param \StructType\SignatureProductionPlaceType $signatureProductionPlace
     * @return \StructType\SignedSignaturePropertiesType
     */
    public function setSignatureProductionPlace(\StructType\SignatureProductionPlaceType $signatureProductionPlace = null)
    {
        $this->SignatureProductionPlace = $signatureProductionPlace;
        return $this;
    }
    /**
     * Get SignerRole value
     * @return \StructType\SignerRoleType|null
     */
    public function getSignerRole()
    {
        return $this->SignerRole;
    }
    /**
     * Set SignerRole value
     * @param \StructType\SignerRoleType $signerRole
     * @return \StructType\SignedSignaturePropertiesType
     */
    public function setSignerRole(\StructType\SignerRoleType $signerRole = null)
    {
        $this->SignerRole = $signerRole;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\SignedSignaturePropertiesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignedSignaturePropertiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
