<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevocationValuesType StructType
 * @subpackage Structs
 */
class RevocationValuesType extends AbstractStructBase
{
    /**
     * The CRLValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CRLValuesType
     */
    public $CRLValues;
    /**
     * The OCSPValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OCSPValuesType
     */
    public $OCSPValues;
    /**
     * The OtherValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OtherCertStatusValuesType
     */
    public $OtherValues;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RevocationValuesType
     * @uses RevocationValuesType::setCRLValues()
     * @uses RevocationValuesType::setOCSPValues()
     * @uses RevocationValuesType::setOtherValues()
     * @uses RevocationValuesType::setId()
     * @param \StructType\CRLValuesType $cRLValues
     * @param \StructType\OCSPValuesType $oCSPValues
     * @param \StructType\OtherCertStatusValuesType $otherValues
     * @param string $id
     */
    public function __construct(\StructType\CRLValuesType $cRLValues = null, \StructType\OCSPValuesType $oCSPValues = null, \StructType\OtherCertStatusValuesType $otherValues = null, $id = null)
    {
        $this
            ->setCRLValues($cRLValues)
            ->setOCSPValues($oCSPValues)
            ->setOtherValues($otherValues)
            ->setId($id);
    }
    /**
     * Get CRLValues value
     * @return \StructType\CRLValuesType|null
     */
    public function getCRLValues()
    {
        return $this->CRLValues;
    }
    /**
     * Set CRLValues value
     * @param \StructType\CRLValuesType $cRLValues
     * @return \StructType\RevocationValuesType
     */
    public function setCRLValues(\StructType\CRLValuesType $cRLValues = null)
    {
        $this->CRLValues = $cRLValues;
        return $this;
    }
    /**
     * Get OCSPValues value
     * @return \StructType\OCSPValuesType|null
     */
    public function getOCSPValues()
    {
        return $this->OCSPValues;
    }
    /**
     * Set OCSPValues value
     * @param \StructType\OCSPValuesType $oCSPValues
     * @return \StructType\RevocationValuesType
     */
    public function setOCSPValues(\StructType\OCSPValuesType $oCSPValues = null)
    {
        $this->OCSPValues = $oCSPValues;
        return $this;
    }
    /**
     * Get OtherValues value
     * @return \StructType\OtherCertStatusValuesType|null
     */
    public function getOtherValues()
    {
        return $this->OtherValues;
    }
    /**
     * Set OtherValues value
     * @param \StructType\OtherCertStatusValuesType $otherValues
     * @return \StructType\RevocationValuesType
     */
    public function setOtherValues(\StructType\OtherCertStatusValuesType $otherValues = null)
    {
        $this->OtherValues = $otherValues;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RevocationValuesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RevocationValuesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
