<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponderIDType StructType
 * @subpackage Structs
 */
class ResponderIDType extends AbstractStructBase
{
    /**
     * The ByName
     * @var string
     */
    public $ByName;
    /**
     * The ByKey
     * @var \StructType\Base64Binary
     */
    public $ByKey;
    /**
     * Constructor method for ResponderIDType
     * @uses ResponderIDType::setByName()
     * @uses ResponderIDType::setByKey()
     * @param string $byName
     * @param \StructType\Base64Binary $byKey
     */
    public function __construct($byName = null, \StructType\Base64Binary $byKey = null)
    {
        $this
            ->setByName($byName)
            ->setByKey($byKey);
    }
    /**
     * Get ByName value
     * @return string|null
     */
    public function getByName()
    {
        return $this->ByName;
    }
    /**
     * Set ByName value
     * @param string $byName
     * @return \StructType\ResponderIDType
     */
    public function setByName($byName = null)
    {
        // validation for constraint: string
        if (!is_null($byName) && !is_string($byName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($byName)), __LINE__);
        }
        $this->ByName = $byName;
        return $this;
    }
    /**
     * Get ByKey value
     * @return \StructType\Base64Binary|null
     */
    public function getByKey()
    {
        return $this->ByKey;
    }
    /**
     * Set ByKey value
     * @param \StructType\Base64Binary $byKey
     * @return \StructType\ResponderIDType
     */
    public function setByKey(\StructType\Base64Binary $byKey = null)
    {
        $this->ByKey = $byKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponderIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
