<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEArchiveReportResponse StructType
 * Meta informations extracted from the WSDL
 * - type: ReadEArchiveReportResponse
 * @subpackage Structs
 */
class ReadEArchiveReportResponse extends AbstractStructBase
{
    /**
     * The EARCHIVEREPORT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Base64Binary[]
     */
    public $EARCHIVEREPORT;
    /**
     * The REQUEST_RETURN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_RETURNType
     */
    public $REQUEST_RETURN;
    /**
     * The ERROR_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\REQUEST_ERRORType
     */
    public $ERROR_TYPE;
    /**
     * Constructor method for ReadEArchiveReportResponse
     * @uses ReadEArchiveReportResponse::setEARCHIVEREPORT()
     * @uses ReadEArchiveReportResponse::setREQUEST_RETURN()
     * @uses ReadEArchiveReportResponse::setERROR_TYPE()
     * @param \StructType\Base64Binary[] $eARCHIVEREPORT
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     */
    public function __construct(array $eARCHIVEREPORT = array(), \StructType\REQUEST_RETURNType $rEQUEST_RETURN = null, \StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this
            ->setEARCHIVEREPORT($eARCHIVEREPORT)
            ->setREQUEST_RETURN($rEQUEST_RETURN)
            ->setERROR_TYPE($eRROR_TYPE);
    }
    /**
     * Get EARCHIVEREPORT value
     * @return \StructType\Base64Binary[]|null
     */
    public function getEARCHIVEREPORT()
    {
        return $this->EARCHIVEREPORT;
    }
    /**
     * Set EARCHIVEREPORT value
     * @throws \InvalidArgumentException
     * @param \StructType\Base64Binary[] $eARCHIVEREPORT
     * @return \StructType\ReadEArchiveReportResponse
     */
    public function setEARCHIVEREPORT(array $eARCHIVEREPORT = array())
    {
        foreach ($eARCHIVEREPORT as $readEArchiveReportResponseEARCHIVEREPORTItem) {
            // validation for constraint: itemType
            if (!$readEArchiveReportResponseEARCHIVEREPORTItem instanceof \StructType\Base64Binary) {
                throw new \InvalidArgumentException(sprintf('The EARCHIVEREPORT property can only contain items of \StructType\Base64Binary, "%s" given', is_object($readEArchiveReportResponseEARCHIVEREPORTItem) ? get_class($readEArchiveReportResponseEARCHIVEREPORTItem) : gettype($readEArchiveReportResponseEARCHIVEREPORTItem)), __LINE__);
            }
        }
        $this->EARCHIVEREPORT = $eARCHIVEREPORT;
        return $this;
    }
    /**
     * Add item to EARCHIVEREPORT value
     * @throws \InvalidArgumentException
     * @param \StructType\Base64Binary $item
     * @return \StructType\ReadEArchiveReportResponse
     */
    public function addToEARCHIVEREPORT(\StructType\Base64Binary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Base64Binary) {
            throw new \InvalidArgumentException(sprintf('The EARCHIVEREPORT property can only contain items of \StructType\Base64Binary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EARCHIVEREPORT[] = $item;
        return $this;
    }
    /**
     * Get REQUEST_RETURN value
     * @return \StructType\REQUEST_RETURNType|null
     */
    public function getREQUEST_RETURN()
    {
        return $this->REQUEST_RETURN;
    }
    /**
     * Set REQUEST_RETURN value
     * @param \StructType\REQUEST_RETURNType $rEQUEST_RETURN
     * @return \StructType\ReadEArchiveReportResponse
     */
    public function setREQUEST_RETURN(\StructType\REQUEST_RETURNType $rEQUEST_RETURN = null)
    {
        $this->REQUEST_RETURN = $rEQUEST_RETURN;
        return $this;
    }
    /**
     * Get ERROR_TYPE value
     * @return \StructType\REQUEST_ERRORType|null
     */
    public function getERROR_TYPE()
    {
        return $this->ERROR_TYPE;
    }
    /**
     * Set ERROR_TYPE value
     * @param \StructType\REQUEST_ERRORType $eRROR_TYPE
     * @return \StructType\ReadEArchiveReportResponse
     */
    public function setERROR_TYPE(\StructType\REQUEST_ERRORType $eRROR_TYPE = null)
    {
        $this->ERROR_TYPE = $eRROR_TYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadEArchiveReportResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
