<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherTimeStampType StructType
 * @subpackage Structs
 */
class OtherTimeStampType extends GenericTimeStampType
{
    /**
     * The ReferenceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ReferenceInfo
     * @var \StructType\ReferenceInfoType[]
     */
    public $ReferenceInfo;
    /**
     * The CanonicalizationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:CanonicalizationMethod
     * @var \StructType\CanonicalizationMethodType
     */
    public $CanonicalizationMethod;
    /**
     * The EncapsulatedTimeStamp
     * @var \StructType\EncapsulatedPKIDataType
     */
    public $EncapsulatedTimeStamp;
    /**
     * The XMLTimeStamp
     * @var \StructType\AnyType
     */
    public $XMLTimeStamp;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for OtherTimeStampType
     * @uses OtherTimeStampType::setReferenceInfo()
     * @uses OtherTimeStampType::setCanonicalizationMethod()
     * @uses OtherTimeStampType::setEncapsulatedTimeStamp()
     * @uses OtherTimeStampType::setXMLTimeStamp()
     * @uses OtherTimeStampType::setId()
     * @param \StructType\ReferenceInfoType[] $referenceInfo
     * @param \StructType\CanonicalizationMethodType $canonicalizationMethod
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp
     * @param \StructType\AnyType $xMLTimeStamp
     * @param string $id
     */
    public function __construct(array $referenceInfo = array(), \StructType\CanonicalizationMethodType $canonicalizationMethod = null, \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp = null, \StructType\AnyType $xMLTimeStamp = null, $id = null)
    {
        $this
            ->setReferenceInfo($referenceInfo)
            ->setCanonicalizationMethod($canonicalizationMethod)
            ->setEncapsulatedTimeStamp($encapsulatedTimeStamp)
            ->setXMLTimeStamp($xMLTimeStamp)
            ->setId($id);
    }
    /**
     * Get ReferenceInfo value
     * @return \StructType\ReferenceInfoType[]|null
     */
    public function getReferenceInfo()
    {
        return $this->ReferenceInfo;
    }
    /**
     * Set ReferenceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceInfoType[] $referenceInfo
     * @return \StructType\OtherTimeStampType
     */
    public function setReferenceInfo(array $referenceInfo = array())
    {
        foreach ($referenceInfo as $otherTimeStampTypeReferenceInfoItem) {
            // validation for constraint: itemType
            if (!$otherTimeStampTypeReferenceInfoItem instanceof \StructType\ReferenceInfoType) {
                throw new \InvalidArgumentException(sprintf('The ReferenceInfo property can only contain items of \StructType\ReferenceInfoType, "%s" given', is_object($otherTimeStampTypeReferenceInfoItem) ? get_class($otherTimeStampTypeReferenceInfoItem) : gettype($otherTimeStampTypeReferenceInfoItem)), __LINE__);
            }
        }
        $this->ReferenceInfo = $referenceInfo;
        return $this;
    }
    /**
     * Add item to ReferenceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceInfoType $item
     * @return \StructType\OtherTimeStampType
     */
    public function addToReferenceInfo(\StructType\ReferenceInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceInfoType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceInfo property can only contain items of \StructType\ReferenceInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReferenceInfo[] = $item;
        return $this;
    }
    /**
     * Get CanonicalizationMethod value
     * @return \StructType\CanonicalizationMethodType|null
     */
    public function getCanonicalizationMethod()
    {
        return $this->CanonicalizationMethod;
    }
    /**
     * Set CanonicalizationMethod value
     * @param \StructType\CanonicalizationMethodType $canonicalizationMethod
     * @return \StructType\OtherTimeStampType
     */
    public function setCanonicalizationMethod(\StructType\CanonicalizationMethodType $canonicalizationMethod = null)
    {
        $this->CanonicalizationMethod = $canonicalizationMethod;
        return $this;
    }
    /**
     * Get EncapsulatedTimeStamp value
     * @return \StructType\EncapsulatedPKIDataType|null
     */
    public function getEncapsulatedTimeStamp()
    {
        return $this->EncapsulatedTimeStamp;
    }
    /**
     * Set EncapsulatedTimeStamp value
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp
     * @return \StructType\OtherTimeStampType
     */
    public function setEncapsulatedTimeStamp(\StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp = null)
    {
        $this->EncapsulatedTimeStamp = $encapsulatedTimeStamp;
        return $this;
    }
    /**
     * Get XMLTimeStamp value
     * @return \StructType\AnyType|null
     */
    public function getXMLTimeStamp()
    {
        return $this->XMLTimeStamp;
    }
    /**
     * Set XMLTimeStamp value
     * @param \StructType\AnyType $xMLTimeStamp
     * @return \StructType\OtherTimeStampType
     */
    public function setXMLTimeStamp(\StructType\AnyType $xMLTimeStamp = null)
    {
        $this->XMLTimeStamp = $xMLTimeStamp;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\OtherTimeStampType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OtherTimeStampType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
