<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoticeReferenceType StructType
 * @subpackage Structs
 */
class NoticeReferenceType extends AbstractStructBase
{
    /**
     * The Organization
     * @var string
     */
    public $Organization;
    /**
     * The NoticeNumbers
     * @var \StructType\IntegerListType
     */
    public $NoticeNumbers;
    /**
     * Constructor method for NoticeReferenceType
     * @uses NoticeReferenceType::setOrganization()
     * @uses NoticeReferenceType::setNoticeNumbers()
     * @param string $organization
     * @param \StructType\IntegerListType $noticeNumbers
     */
    public function __construct($organization = null, \StructType\IntegerListType $noticeNumbers = null)
    {
        $this
            ->setOrganization($organization)
            ->setNoticeNumbers($noticeNumbers);
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \StructType\NoticeReferenceType
     */
    public function setOrganization($organization = null)
    {
        // validation for constraint: string
        if (!is_null($organization) && !is_string($organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organization)), __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get NoticeNumbers value
     * @return \StructType\IntegerListType|null
     */
    public function getNoticeNumbers()
    {
        return $this->NoticeNumbers;
    }
    /**
     * Set NoticeNumbers value
     * @param \StructType\IntegerListType $noticeNumbers
     * @return \StructType\NoticeReferenceType
     */
    public function setNoticeNumbers(\StructType\IntegerListType $noticeNumbers = null)
    {
        $this->NoticeNumbers = $noticeNumbers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NoticeReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
