<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericTimeStampType StructType
 * @subpackage Structs
 */
abstract class GenericTimeStampType extends AbstractStructBase
{
    /**
     * The Include
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: Include
     * @var \StructType\IncludeType[]
     */
    public $Include;
    /**
     * The ReferenceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ReferenceInfo
     * @var \StructType\ReferenceInfoType[]
     */
    public $ReferenceInfo;
    /**
     * The CanonicalizationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:CanonicalizationMethod
     * @var \StructType\CanonicalizationMethodType
     */
    public $CanonicalizationMethod;
    /**
     * The EncapsulatedTimeStamp
     * @var \StructType\EncapsulatedPKIDataType
     */
    public $EncapsulatedTimeStamp;
    /**
     * The XMLTimeStamp
     * @var \StructType\AnyType
     */
    public $XMLTimeStamp;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for GenericTimeStampType
     * @uses GenericTimeStampType::setInclude()
     * @uses GenericTimeStampType::setReferenceInfo()
     * @uses GenericTimeStampType::setCanonicalizationMethod()
     * @uses GenericTimeStampType::setEncapsulatedTimeStamp()
     * @uses GenericTimeStampType::setXMLTimeStamp()
     * @uses GenericTimeStampType::setId()
     * @param \StructType\IncludeType[] $include
     * @param \StructType\ReferenceInfoType[] $referenceInfo
     * @param \StructType\CanonicalizationMethodType $canonicalizationMethod
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp
     * @param \StructType\AnyType $xMLTimeStamp
     * @param string $id
     */
    public function __construct(array $include = array(), array $referenceInfo = array(), \StructType\CanonicalizationMethodType $canonicalizationMethod = null, \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp = null, \StructType\AnyType $xMLTimeStamp = null, $id = null)
    {
        $this
            ->setInclude($include)
            ->setReferenceInfo($referenceInfo)
            ->setCanonicalizationMethod($canonicalizationMethod)
            ->setEncapsulatedTimeStamp($encapsulatedTimeStamp)
            ->setXMLTimeStamp($xMLTimeStamp)
            ->setId($id);
    }
    /**
     * Get Include value
     * @return \StructType\IncludeType[]|null
     */
    public function getInclude()
    {
        return $this->Include;
    }
    /**
     * Set Include value
     * @throws \InvalidArgumentException
     * @param \StructType\IncludeType[] $include
     * @return \StructType\GenericTimeStampType
     */
    public function setInclude(array $include = array())
    {
        foreach ($include as $genericTimeStampTypeIncludeItem) {
            // validation for constraint: itemType
            if (!$genericTimeStampTypeIncludeItem instanceof \StructType\IncludeType) {
                throw new \InvalidArgumentException(sprintf('The Include property can only contain items of \StructType\IncludeType, "%s" given', is_object($genericTimeStampTypeIncludeItem) ? get_class($genericTimeStampTypeIncludeItem) : gettype($genericTimeStampTypeIncludeItem)), __LINE__);
            }
        }
        $this->Include = $include;
        return $this;
    }
    /**
     * Add item to Include value
     * @throws \InvalidArgumentException
     * @param \StructType\IncludeType $item
     * @return \StructType\GenericTimeStampType
     */
    public function addToInclude(\StructType\IncludeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IncludeType) {
            throw new \InvalidArgumentException(sprintf('The Include property can only contain items of \StructType\IncludeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Include[] = $item;
        return $this;
    }
    /**
     * Get ReferenceInfo value
     * @return \StructType\ReferenceInfoType[]|null
     */
    public function getReferenceInfo()
    {
        return $this->ReferenceInfo;
    }
    /**
     * Set ReferenceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceInfoType[] $referenceInfo
     * @return \StructType\GenericTimeStampType
     */
    public function setReferenceInfo(array $referenceInfo = array())
    {
        foreach ($referenceInfo as $genericTimeStampTypeReferenceInfoItem) {
            // validation for constraint: itemType
            if (!$genericTimeStampTypeReferenceInfoItem instanceof \StructType\ReferenceInfoType) {
                throw new \InvalidArgumentException(sprintf('The ReferenceInfo property can only contain items of \StructType\ReferenceInfoType, "%s" given', is_object($genericTimeStampTypeReferenceInfoItem) ? get_class($genericTimeStampTypeReferenceInfoItem) : gettype($genericTimeStampTypeReferenceInfoItem)), __LINE__);
            }
        }
        $this->ReferenceInfo = $referenceInfo;
        return $this;
    }
    /**
     * Add item to ReferenceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceInfoType $item
     * @return \StructType\GenericTimeStampType
     */
    public function addToReferenceInfo(\StructType\ReferenceInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceInfoType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceInfo property can only contain items of \StructType\ReferenceInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReferenceInfo[] = $item;
        return $this;
    }
    /**
     * Get CanonicalizationMethod value
     * @return \StructType\CanonicalizationMethodType|null
     */
    public function getCanonicalizationMethod()
    {
        return $this->CanonicalizationMethod;
    }
    /**
     * Set CanonicalizationMethod value
     * @param \StructType\CanonicalizationMethodType $canonicalizationMethod
     * @return \StructType\GenericTimeStampType
     */
    public function setCanonicalizationMethod(\StructType\CanonicalizationMethodType $canonicalizationMethod = null)
    {
        $this->CanonicalizationMethod = $canonicalizationMethod;
        return $this;
    }
    /**
     * Get EncapsulatedTimeStamp value
     * @return \StructType\EncapsulatedPKIDataType|null
     */
    public function getEncapsulatedTimeStamp()
    {
        return $this->EncapsulatedTimeStamp;
    }
    /**
     * Set EncapsulatedTimeStamp value
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp
     * @return \StructType\GenericTimeStampType
     */
    public function setEncapsulatedTimeStamp(\StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp = null)
    {
        $this->EncapsulatedTimeStamp = $encapsulatedTimeStamp;
        return $this;
    }
    /**
     * Get XMLTimeStamp value
     * @return \StructType\AnyType|null
     */
    public function getXMLTimeStamp()
    {
        return $this->XMLTimeStamp;
    }
    /**
     * Set XMLTimeStamp value
     * @param \StructType\AnyType $xMLTimeStamp
     * @return \StructType\GenericTimeStampType
     */
    public function setXMLTimeStamp(\StructType\AnyType $xMLTimeStamp = null)
    {
        $this->XMLTimeStamp = $xMLTimeStamp;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\GenericTimeStampType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericTimeStampType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
