<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FILEType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Holds File Info
 * @subpackage Structs
 */
class FILEType extends ENTITYBaseType
{
    /**
     * The CREATE_USER_INFO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CREATE_USER_INFO
     */
    public $CREATE_USER_INFO;
    /**
     * The FILENAME
     * Meta informations extracted from the WSDL
     * - documentation: Filename
     * - maxLength: 256
     * @var string
     */
    public $FILENAME;
    /**
     * The FILETYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Defines filetype such as PDF, XSL etc.
     * - maxLength: 10
     * @var string
     */
    public $FILETYPE;
    /**
     * The OPERATION_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Operation Code
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $OPERATION_CODE;
    /**
     * The CONTENT
     * Meta informations extracted from the WSDL
     * - documentation: This is the content of the file
     * - minOccurs: 0
     * @var mixed
     */
    public $CONTENT;
    /**
     * The INTL_TXN_ID
     * Meta informations extracted from the WSDL
     * - documentation: INTL TXN ID if related to a Workflow
     * - minOccurs: 0
     * @var int
     */
    public $INTL_TXN_ID;
    /**
     * Constructor method for FILEType
     * @uses FILEType::setCREATE_USER_INFO()
     * @uses FILEType::setFILENAME()
     * @uses FILEType::setFILETYPE()
     * @uses FILEType::setOPERATION_CODE()
     * @uses FILEType::setCONTENT()
     * @uses FILEType::setINTL_TXN_ID()
     * @param \StructType\CREATE_USER_INFO $cREATE_USER_INFO
     * @param string $fILENAME
     * @param string $fILETYPE
     * @param string $oPERATION_CODE
     * @param mixed $cONTENT
     * @param int $iNTL_TXN_ID
     */
    public function __construct(\StructType\CREATE_USER_INFO $cREATE_USER_INFO = null, $fILENAME = null, $fILETYPE = null, $oPERATION_CODE = null, $cONTENT = null, $iNTL_TXN_ID = null)
    {
        $this
            ->setCREATE_USER_INFO($cREATE_USER_INFO)
            ->setFILENAME($fILENAME)
            ->setFILETYPE($fILETYPE)
            ->setOPERATION_CODE($oPERATION_CODE)
            ->setCONTENT($cONTENT)
            ->setINTL_TXN_ID($iNTL_TXN_ID);
    }
    /**
     * Get CREATE_USER_INFO value
     * @return \StructType\CREATE_USER_INFO|null
     */
    public function getCREATE_USER_INFO()
    {
        return $this->CREATE_USER_INFO;
    }
    /**
     * Set CREATE_USER_INFO value
     * @param \StructType\CREATE_USER_INFO $cREATE_USER_INFO
     * @return \StructType\FILEType
     */
    public function setCREATE_USER_INFO(\StructType\CREATE_USER_INFO $cREATE_USER_INFO = null)
    {
        $this->CREATE_USER_INFO = $cREATE_USER_INFO;
        return $this;
    }
    /**
     * Get FILENAME value
     * @return string|null
     */
    public function getFILENAME()
    {
        return $this->FILENAME;
    }
    /**
     * Set FILENAME value
     * @param string $fILENAME
     * @return \StructType\FILEType
     */
    public function setFILENAME($fILENAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fILENAME) && strlen($fILENAME) > 256) || (is_array($fILENAME) && count($fILENAME) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($fILENAME) ? strlen($fILENAME) : count($fILENAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fILENAME) && !is_string($fILENAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fILENAME)), __LINE__);
        }
        $this->FILENAME = $fILENAME;
        return $this;
    }
    /**
     * Get FILETYPE value
     * @return string|null
     */
    public function getFILETYPE()
    {
        return $this->FILETYPE;
    }
    /**
     * Set FILETYPE value
     * @param string $fILETYPE
     * @return \StructType\FILEType
     */
    public function setFILETYPE($fILETYPE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fILETYPE) && strlen($fILETYPE) > 10) || (is_array($fILETYPE) && count($fILETYPE) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($fILETYPE) ? strlen($fILETYPE) : count($fILETYPE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fILETYPE) && !is_string($fILETYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fILETYPE)), __LINE__);
        }
        $this->FILETYPE = $fILETYPE;
        return $this;
    }
    /**
     * Get OPERATION_CODE value
     * @return string|null
     */
    public function getOPERATION_CODE()
    {
        return $this->OPERATION_CODE;
    }
    /**
     * Set OPERATION_CODE value
     * @param string $oPERATION_CODE
     * @return \StructType\FILEType
     */
    public function setOPERATION_CODE($oPERATION_CODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION_CODE) && strlen($oPERATION_CODE) > 32) || (is_array($oPERATION_CODE) && count($oPERATION_CODE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($oPERATION_CODE) ? strlen($oPERATION_CODE) : count($oPERATION_CODE)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oPERATION_CODE) && strlen($oPERATION_CODE) < 1) || (is_array($oPERATION_CODE) && count($oPERATION_CODE) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION_CODE) && !is_string($oPERATION_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION_CODE)), __LINE__);
        }
        $this->OPERATION_CODE = $oPERATION_CODE;
        return $this;
    }
    /**
     * Get CONTENT value
     * @return mixed|null
     */
    public function getCONTENT()
    {
        return $this->CONTENT;
    }
    /**
     * Set CONTENT value
     * @param mixed $cONTENT
     * @return \StructType\FILEType
     */
    public function setCONTENT($cONTENT = null)
    {
        $this->CONTENT = $cONTENT;
        return $this;
    }
    /**
     * Get INTL_TXN_ID value
     * @return int|null
     */
    public function getINTL_TXN_ID()
    {
        return $this->INTL_TXN_ID;
    }
    /**
     * Set INTL_TXN_ID value
     * @param int $iNTL_TXN_ID
     * @return \StructType\FILEType
     */
    public function setINTL_TXN_ID($iNTL_TXN_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iNTL_TXN_ID) && !is_numeric($iNTL_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iNTL_TXN_ID)), __LINE__);
        }
        $this->INTL_TXN_ID = $iNTL_TXN_ID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FILEType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
