<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eArsivRaporu StructType
 * Meta informations extracted from the WSDL
 * - documentation: eArsiv Rapor Bilgileri.
 * @subpackage Structs
 */
class EArsivRaporu extends AbstractStructBase
{
    /**
     * The baslik
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BaslikType
     */
    public $baslik;
    /**
     * The fatura
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FaturaType[]
     */
    public $fatura;
    /**
     * The faturaIptal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FaturaIptalType[]
     */
    public $faturaIptal;
    /**
     * Constructor method for eArsivRaporu
     * @uses EArsivRaporu::setBaslik()
     * @uses EArsivRaporu::setFatura()
     * @uses EArsivRaporu::setFaturaIptal()
     * @param \StructType\BaslikType $baslik
     * @param \StructType\FaturaType[] $fatura
     * @param \StructType\FaturaIptalType[] $faturaIptal
     */
    public function __construct(\StructType\BaslikType $baslik = null, array $fatura = array(), array $faturaIptal = array())
    {
        $this
            ->setBaslik($baslik)
            ->setFatura($fatura)
            ->setFaturaIptal($faturaIptal);
    }
    /**
     * Get baslik value
     * @return \StructType\BaslikType
     */
    public function getBaslik()
    {
        return $this->baslik;
    }
    /**
     * Set baslik value
     * @param \StructType\BaslikType $baslik
     * @return \StructType\EArsivRaporu
     */
    public function setBaslik(\StructType\BaslikType $baslik = null)
    {
        $this->baslik = $baslik;
        return $this;
    }
    /**
     * Get fatura value
     * @return \StructType\FaturaType[]|null
     */
    public function getFatura()
    {
        return $this->fatura;
    }
    /**
     * Set fatura value
     * @throws \InvalidArgumentException
     * @param \StructType\FaturaType[] $fatura
     * @return \StructType\EArsivRaporu
     */
    public function setFatura(array $fatura = array())
    {
        foreach ($fatura as $eArsivRaporuFaturaItem) {
            // validation for constraint: itemType
            if (!$eArsivRaporuFaturaItem instanceof \StructType\FaturaType) {
                throw new \InvalidArgumentException(sprintf('The fatura property can only contain items of \StructType\FaturaType, "%s" given', is_object($eArsivRaporuFaturaItem) ? get_class($eArsivRaporuFaturaItem) : gettype($eArsivRaporuFaturaItem)), __LINE__);
            }
        }
        $this->fatura = $fatura;
        return $this;
    }
    /**
     * Add item to fatura value
     * @throws \InvalidArgumentException
     * @param \StructType\FaturaType $item
     * @return \StructType\EArsivRaporu
     */
    public function addToFatura(\StructType\FaturaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FaturaType) {
            throw new \InvalidArgumentException(sprintf('The fatura property can only contain items of \StructType\FaturaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->fatura[] = $item;
        return $this;
    }
    /**
     * Get faturaIptal value
     * @return \StructType\FaturaIptalType[]|null
     */
    public function getFaturaIptal()
    {
        return $this->faturaIptal;
    }
    /**
     * Set faturaIptal value
     * @throws \InvalidArgumentException
     * @param \StructType\FaturaIptalType[] $faturaIptal
     * @return \StructType\EArsivRaporu
     */
    public function setFaturaIptal(array $faturaIptal = array())
    {
        foreach ($faturaIptal as $eArsivRaporuFaturaIptalItem) {
            // validation for constraint: itemType
            if (!$eArsivRaporuFaturaIptalItem instanceof \StructType\FaturaIptalType) {
                throw new \InvalidArgumentException(sprintf('The faturaIptal property can only contain items of \StructType\FaturaIptalType, "%s" given', is_object($eArsivRaporuFaturaIptalItem) ? get_class($eArsivRaporuFaturaIptalItem) : gettype($eArsivRaporuFaturaIptalItem)), __LINE__);
            }
        }
        $this->faturaIptal = $faturaIptal;
        return $this;
    }
    /**
     * Add item to faturaIptal value
     * @throws \InvalidArgumentException
     * @param \StructType\FaturaIptalType $item
     * @return \StructType\EArsivRaporu
     */
    public function addToFaturaIptal(\StructType\FaturaIptalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FaturaIptalType) {
            throw new \InvalidArgumentException(sprintf('The faturaIptal property can only contain items of \StructType\FaturaIptalType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->faturaIptal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EArsivRaporu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
