<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitmentTypeIndicationType StructType
 * @subpackage Structs
 */
class CommitmentTypeIndicationType extends AbstractStructBase
{
    /**
     * The CommitmentTypeId
     * @var \StructType\ObjectIdentifierType
     */
    public $CommitmentTypeId;
    /**
     * The ObjectReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ObjectReference;
    /**
     * The AllSignedDataObjects
     * @var mixed
     */
    public $AllSignedDataObjects;
    /**
     * The CommitmentTypeQualifiers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommitmentTypeQualifiersListType
     */
    public $CommitmentTypeQualifiers;
    /**
     * Constructor method for CommitmentTypeIndicationType
     * @uses CommitmentTypeIndicationType::setCommitmentTypeId()
     * @uses CommitmentTypeIndicationType::setObjectReference()
     * @uses CommitmentTypeIndicationType::setAllSignedDataObjects()
     * @uses CommitmentTypeIndicationType::setCommitmentTypeQualifiers()
     * @param \StructType\ObjectIdentifierType $commitmentTypeId
     * @param string[] $objectReference
     * @param mixed $allSignedDataObjects
     * @param \StructType\CommitmentTypeQualifiersListType $commitmentTypeQualifiers
     */
    public function __construct(\StructType\ObjectIdentifierType $commitmentTypeId = null, array $objectReference = array(), $allSignedDataObjects = null, \StructType\CommitmentTypeQualifiersListType $commitmentTypeQualifiers = null)
    {
        $this
            ->setCommitmentTypeId($commitmentTypeId)
            ->setObjectReference($objectReference)
            ->setAllSignedDataObjects($allSignedDataObjects)
            ->setCommitmentTypeQualifiers($commitmentTypeQualifiers);
    }
    /**
     * Get CommitmentTypeId value
     * @return \StructType\ObjectIdentifierType|null
     */
    public function getCommitmentTypeId()
    {
        return $this->CommitmentTypeId;
    }
    /**
     * Set CommitmentTypeId value
     * @param \StructType\ObjectIdentifierType $commitmentTypeId
     * @return \StructType\CommitmentTypeIndicationType
     */
    public function setCommitmentTypeId(\StructType\ObjectIdentifierType $commitmentTypeId = null)
    {
        $this->CommitmentTypeId = $commitmentTypeId;
        return $this;
    }
    /**
     * Get ObjectReference value
     * @return string[]|null
     */
    public function getObjectReference()
    {
        return $this->ObjectReference;
    }
    /**
     * Set ObjectReference value
     * @throws \InvalidArgumentException
     * @param string[] $objectReference
     * @return \StructType\CommitmentTypeIndicationType
     */
    public function setObjectReference(array $objectReference = array())
    {
        foreach ($objectReference as $commitmentTypeIndicationTypeObjectReferenceItem) {
            // validation for constraint: itemType
            if (!is_string($commitmentTypeIndicationTypeObjectReferenceItem)) {
                throw new \InvalidArgumentException(sprintf('The ObjectReference property can only contain items of anyURI, "%s" given', is_object($commitmentTypeIndicationTypeObjectReferenceItem) ? get_class($commitmentTypeIndicationTypeObjectReferenceItem) : gettype($commitmentTypeIndicationTypeObjectReferenceItem)), __LINE__);
            }
        }
        $this->ObjectReference = $objectReference;
        return $this;
    }
    /**
     * Add item to ObjectReference value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CommitmentTypeIndicationType
     */
    public function addToObjectReference($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ObjectReference property can only contain items of anyURI, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ObjectReference[] = $item;
        return $this;
    }
    /**
     * Get AllSignedDataObjects value
     * @return mixed|null
     */
    public function getAllSignedDataObjects()
    {
        return $this->AllSignedDataObjects;
    }
    /**
     * Set AllSignedDataObjects value
     * @param mixed $allSignedDataObjects
     * @return \StructType\CommitmentTypeIndicationType
     */
    public function setAllSignedDataObjects($allSignedDataObjects = null)
    {
        $this->AllSignedDataObjects = $allSignedDataObjects;
        return $this;
    }
    /**
     * Get CommitmentTypeQualifiers value
     * @return \StructType\CommitmentTypeQualifiersListType|null
     */
    public function getCommitmentTypeQualifiers()
    {
        return $this->CommitmentTypeQualifiers;
    }
    /**
     * Set CommitmentTypeQualifiers value
     * @param \StructType\CommitmentTypeQualifiersListType $commitmentTypeQualifiers
     * @return \StructType\CommitmentTypeIndicationType
     */
    public function setCommitmentTypeQualifiers(\StructType\CommitmentTypeQualifiersListType $commitmentTypeQualifiers = null)
    {
        $this->CommitmentTypeQualifiers = $commitmentTypeQualifiers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommitmentTypeIndicationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
