<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CertifiedRolesListType StructType
 * @subpackage Structs
 */
class CertifiedRolesListType extends AbstractStructBase
{
    /**
     * The CertifiedRole
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\EncapsulatedPKIDataType[]
     */
    public $CertifiedRole;
    /**
     * Constructor method for CertifiedRolesListType
     * @uses CertifiedRolesListType::setCertifiedRole()
     * @param \StructType\EncapsulatedPKIDataType[] $certifiedRole
     */
    public function __construct(array $certifiedRole = array())
    {
        $this
            ->setCertifiedRole($certifiedRole);
    }
    /**
     * Get CertifiedRole value
     * @return \StructType\EncapsulatedPKIDataType[]|null
     */
    public function getCertifiedRole()
    {
        return $this->CertifiedRole;
    }
    /**
     * Set CertifiedRole value
     * @throws \InvalidArgumentException
     * @param \StructType\EncapsulatedPKIDataType[] $certifiedRole
     * @return \StructType\CertifiedRolesListType
     */
    public function setCertifiedRole(array $certifiedRole = array())
    {
        foreach ($certifiedRole as $certifiedRolesListTypeCertifiedRoleItem) {
            // validation for constraint: itemType
            if (!$certifiedRolesListTypeCertifiedRoleItem instanceof \StructType\EncapsulatedPKIDataType) {
                throw new \InvalidArgumentException(sprintf('The CertifiedRole property can only contain items of \StructType\EncapsulatedPKIDataType, "%s" given', is_object($certifiedRolesListTypeCertifiedRoleItem) ? get_class($certifiedRolesListTypeCertifiedRoleItem) : gettype($certifiedRolesListTypeCertifiedRoleItem)), __LINE__);
            }
        }
        $this->CertifiedRole = $certifiedRole;
        return $this;
    }
    /**
     * Add item to CertifiedRole value
     * @throws \InvalidArgumentException
     * @param \StructType\EncapsulatedPKIDataType $item
     * @return \StructType\CertifiedRolesListType
     */
    public function addToCertifiedRole(\StructType\EncapsulatedPKIDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EncapsulatedPKIDataType) {
            throw new \InvalidArgumentException(sprintf('The CertifiedRole property can only contain items of \StructType\EncapsulatedPKIDataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CertifiedRole[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertifiedRolesListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
