<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CertIDType StructType
 * @subpackage Structs
 */
class CertIDType extends AbstractStructBase
{
    /**
     * The CertDigest
     * @var \StructType\DigestAlgAndValueType
     */
    public $CertDigest;
    /**
     * The IssuerSerial
     * @var \StructType\X509IssuerSerialType
     */
    public $IssuerSerial;
    /**
     * The URI
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * Constructor method for CertIDType
     * @uses CertIDType::setCertDigest()
     * @uses CertIDType::setIssuerSerial()
     * @uses CertIDType::setURI()
     * @param \StructType\DigestAlgAndValueType $certDigest
     * @param \StructType\X509IssuerSerialType $issuerSerial
     * @param string $uRI
     */
    public function __construct(\StructType\DigestAlgAndValueType $certDigest = null, \StructType\X509IssuerSerialType $issuerSerial = null, $uRI = null)
    {
        $this
            ->setCertDigest($certDigest)
            ->setIssuerSerial($issuerSerial)
            ->setURI($uRI);
    }
    /**
     * Get CertDigest value
     * @return \StructType\DigestAlgAndValueType|null
     */
    public function getCertDigest()
    {
        return $this->CertDigest;
    }
    /**
     * Set CertDigest value
     * @param \StructType\DigestAlgAndValueType $certDigest
     * @return \StructType\CertIDType
     */
    public function setCertDigest(\StructType\DigestAlgAndValueType $certDigest = null)
    {
        $this->CertDigest = $certDigest;
        return $this;
    }
    /**
     * Get IssuerSerial value
     * @return \StructType\X509IssuerSerialType|null
     */
    public function getIssuerSerial()
    {
        return $this->IssuerSerial;
    }
    /**
     * Set IssuerSerial value
     * @param \StructType\X509IssuerSerialType $issuerSerial
     * @return \StructType\CertIDType
     */
    public function setIssuerSerial(\StructType\X509IssuerSerialType $issuerSerial = null)
    {
        $this->IssuerSerial = $issuerSerial;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\CertIDType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
