<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CertIDListType StructType
 * @subpackage Structs
 */
class CertIDListType extends AbstractStructBase
{
    /**
     * The Cert
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CertIDType[]
     */
    public $Cert;
    /**
     * Constructor method for CertIDListType
     * @uses CertIDListType::setCert()
     * @param \StructType\CertIDType[] $cert
     */
    public function __construct(array $cert = array())
    {
        $this
            ->setCert($cert);
    }
    /**
     * Get Cert value
     * @return \StructType\CertIDType[]|null
     */
    public function getCert()
    {
        return $this->Cert;
    }
    /**
     * Set Cert value
     * @throws \InvalidArgumentException
     * @param \StructType\CertIDType[] $cert
     * @return \StructType\CertIDListType
     */
    public function setCert(array $cert = array())
    {
        foreach ($cert as $certIDListTypeCertItem) {
            // validation for constraint: itemType
            if (!$certIDListTypeCertItem instanceof \StructType\CertIDType) {
                throw new \InvalidArgumentException(sprintf('The Cert property can only contain items of \StructType\CertIDType, "%s" given', is_object($certIDListTypeCertItem) ? get_class($certIDListTypeCertItem) : gettype($certIDListTypeCertItem)), __LINE__);
            }
        }
        $this->Cert = $cert;
        return $this;
    }
    /**
     * Add item to Cert value
     * @throws \InvalidArgumentException
     * @param \StructType\CertIDType $item
     * @return \StructType\CertIDListType
     */
    public function addToCert(\StructType\CertIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CertIDType) {
            throw new \InvalidArgumentException(sprintf('The Cert property can only contain items of \StructType\CertIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Cert[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertIDListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
