<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CRLIdentifierType StructType
 * @subpackage Structs
 */
class CRLIdentifierType extends AbstractStructBase
{
    /**
     * The Issuer
     * @var string
     */
    public $Issuer;
    /**
     * The IssueTime
     * @var string
     */
    public $IssueTime;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Number;
    /**
     * The URI
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * Constructor method for CRLIdentifierType
     * @uses CRLIdentifierType::setIssuer()
     * @uses CRLIdentifierType::setIssueTime()
     * @uses CRLIdentifierType::setNumber()
     * @uses CRLIdentifierType::setURI()
     * @param string $issuer
     * @param string $issueTime
     * @param int $number
     * @param string $uRI
     */
    public function __construct($issuer = null, $issueTime = null, $number = null, $uRI = null)
    {
        $this
            ->setIssuer($issuer)
            ->setIssueTime($issueTime)
            ->setNumber($number)
            ->setURI($uRI);
    }
    /**
     * Get Issuer value
     * @return string|null
     */
    public function getIssuer()
    {
        return $this->Issuer;
    }
    /**
     * Set Issuer value
     * @param string $issuer
     * @return \StructType\CRLIdentifierType
     */
    public function setIssuer($issuer = null)
    {
        // validation for constraint: string
        if (!is_null($issuer) && !is_string($issuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuer)), __LINE__);
        }
        $this->Issuer = $issuer;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return string|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param string $issueTime
     * @return \StructType\CRLIdentifierType
     */
    public function setIssueTime($issueTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueTime) && !is_string($issueTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueTime)), __LINE__);
        }
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\CRLIdentifierType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !is_numeric($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\CRLIdentifierType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CRLIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
