<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CREATE_USER_INFO StructType
 * @subpackage Structs
 */
class CREATE_USER_INFO extends AbstractStructBase
{
    /**
     * The FIRST_NAME
     * Meta informations extracted from the WSDL
     * - documentation: First name
     * - maxLength: 256
     * @var string
     */
    public $FIRST_NAME;
    /**
     * The LAST_NAME
     * Meta informations extracted from the WSDL
     * - documentation: Last name
     * - maxLength: 64
     * @var string
     */
    public $LAST_NAME;
    /**
     * Constructor method for CREATE_USER_INFO
     * @uses CREATE_USER_INFO::setFIRST_NAME()
     * @uses CREATE_USER_INFO::setLAST_NAME()
     * @param string $fIRST_NAME
     * @param string $lAST_NAME
     */
    public function __construct($fIRST_NAME = null, $lAST_NAME = null)
    {
        $this
            ->setFIRST_NAME($fIRST_NAME)
            ->setLAST_NAME($lAST_NAME);
    }
    /**
     * Get FIRST_NAME value
     * @return string|null
     */
    public function getFIRST_NAME()
    {
        return $this->FIRST_NAME;
    }
    /**
     * Set FIRST_NAME value
     * @param string $fIRST_NAME
     * @return \StructType\CREATE_USER_INFO
     */
    public function setFIRST_NAME($fIRST_NAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fIRST_NAME) && strlen($fIRST_NAME) > 256) || (is_array($fIRST_NAME) && count($fIRST_NAME) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($fIRST_NAME) ? strlen($fIRST_NAME) : count($fIRST_NAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fIRST_NAME) && !is_string($fIRST_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fIRST_NAME)), __LINE__);
        }
        $this->FIRST_NAME = $fIRST_NAME;
        return $this;
    }
    /**
     * Get LAST_NAME value
     * @return string|null
     */
    public function getLAST_NAME()
    {
        return $this->LAST_NAME;
    }
    /**
     * Set LAST_NAME value
     * @param string $lAST_NAME
     * @return \StructType\CREATE_USER_INFO
     */
    public function setLAST_NAME($lAST_NAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lAST_NAME) && strlen($lAST_NAME) > 64) || (is_array($lAST_NAME) && count($lAST_NAME) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($lAST_NAME) ? strlen($lAST_NAME) : count($lAST_NAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lAST_NAME) && !is_string($lAST_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lAST_NAME)), __LINE__);
        }
        $this->LAST_NAME = $lAST_NAME;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CREATE_USER_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
