<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for COMMENTSETType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Holds Comment Set Info
 * @subpackage Structs
 */
class COMMENTSETType extends ENTITYBaseType
{
    /**
     * The COMMENT_SET_ID
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID indicating a set of comments. If not defined may be set to -1
     * @var int
     */
    public $COMMENT_SET_ID;
    /**
     * The COMMENT
     * Meta informations extracted from the WSDL
     * - documentation: Comments
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\COMMENTType[]
     */
    public $COMMENT;
    /**
     * Constructor method for COMMENTSETType
     * @uses COMMENTSETType::setCOMMENT_SET_ID()
     * @uses COMMENTSETType::setCOMMENT()
     * @param int $cOMMENT_SET_ID
     * @param \StructType\COMMENTType[] $cOMMENT
     */
    public function __construct($cOMMENT_SET_ID = null, array $cOMMENT = array())
    {
        $this
            ->setCOMMENT_SET_ID($cOMMENT_SET_ID)
            ->setCOMMENT($cOMMENT);
    }
    /**
     * Get COMMENT_SET_ID value
     * @return int|null
     */
    public function getCOMMENT_SET_ID()
    {
        return $this->COMMENT_SET_ID;
    }
    /**
     * Set COMMENT_SET_ID value
     * @param int $cOMMENT_SET_ID
     * @return \StructType\COMMENTSETType
     */
    public function setCOMMENT_SET_ID($cOMMENT_SET_ID = null)
    {
        // validation for constraint: int
        if (!is_null($cOMMENT_SET_ID) && !is_numeric($cOMMENT_SET_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cOMMENT_SET_ID)), __LINE__);
        }
        $this->COMMENT_SET_ID = $cOMMENT_SET_ID;
        return $this;
    }
    /**
     * Get COMMENT value
     * @return \StructType\COMMENTType[]|null
     */
    public function getCOMMENT()
    {
        return $this->COMMENT;
    }
    /**
     * Set COMMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\COMMENTType[] $cOMMENT
     * @return \StructType\COMMENTSETType
     */
    public function setCOMMENT(array $cOMMENT = array())
    {
        foreach ($cOMMENT as $cOMMENTSETTypeCOMMENTItem) {
            // validation for constraint: itemType
            if (!$cOMMENTSETTypeCOMMENTItem instanceof \StructType\COMMENTType) {
                throw new \InvalidArgumentException(sprintf('The COMMENT property can only contain items of \StructType\COMMENTType, "%s" given', is_object($cOMMENTSETTypeCOMMENTItem) ? get_class($cOMMENTSETTypeCOMMENTItem) : gettype($cOMMENTSETTypeCOMMENTItem)), __LINE__);
            }
        }
        $this->COMMENT = $cOMMENT;
        return $this;
    }
    /**
     * Add item to COMMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\COMMENTType $item
     * @return \StructType\COMMENTSETType
     */
    public function addToCOMMENT(\StructType\COMMENTType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\COMMENTType) {
            throw new \InvalidArgumentException(sprintf('The COMMENT property can only contain items of \StructType\COMMENTType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->COMMENT[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\COMMENTSETType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
