<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArchiveInvoiceReadRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ArchiveInvoiceReadRequest
 * @subpackage Structs
 */
class ArchiveInvoiceReadRequest extends AbstractStructBase
{
    /**
     * The REQUEST_HEADER
     * @var \StructType\REQUEST_HEADERType
     */
    public $REQUEST_HEADER;
    /**
     * The INVOICEID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $INVOICEID;
    /**
     * The PORTAL_DIRECTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PORTAL_DIRECTION;
    /**
     * The EXTERNAL_ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EXTERNAL_ID;
    /**
     * The PROFILE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PROFILE;
    /**
     * Constructor method for ArchiveInvoiceReadRequest
     * @uses ArchiveInvoiceReadRequest::setREQUEST_HEADER()
     * @uses ArchiveInvoiceReadRequest::setINVOICEID()
     * @uses ArchiveInvoiceReadRequest::setPORTAL_DIRECTION()
     * @uses ArchiveInvoiceReadRequest::setEXTERNAL_ID()
     * @uses ArchiveInvoiceReadRequest::setPROFILE()
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @param string $iNVOICEID
     * @param string $pORTAL_DIRECTION
     * @param int $eXTERNAL_ID
     * @param string $pROFILE
     */
    public function __construct(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null, $iNVOICEID = null, $pORTAL_DIRECTION = null, $eXTERNAL_ID = null, $pROFILE = null)
    {
        $this
            ->setREQUEST_HEADER($rEQUEST_HEADER)
            ->setINVOICEID($iNVOICEID)
            ->setPORTAL_DIRECTION($pORTAL_DIRECTION)
            ->setEXTERNAL_ID($eXTERNAL_ID)
            ->setPROFILE($pROFILE);
    }
    /**
     * Get REQUEST_HEADER value
     * @return \StructType\REQUEST_HEADERType|null
     */
    public function getREQUEST_HEADER()
    {
        return $this->REQUEST_HEADER;
    }
    /**
     * Set REQUEST_HEADER value
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @return \StructType\ArchiveInvoiceReadRequest
     */
    public function setREQUEST_HEADER(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this->REQUEST_HEADER = $rEQUEST_HEADER;
        return $this;
    }
    /**
     * Get INVOICEID value
     * @return string|null
     */
    public function getINVOICEID()
    {
        return $this->INVOICEID;
    }
    /**
     * Set INVOICEID value
     * @param string $iNVOICEID
     * @return \StructType\ArchiveInvoiceReadRequest
     */
    public function setINVOICEID($iNVOICEID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICEID) && !is_string($iNVOICEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICEID)), __LINE__);
        }
        $this->INVOICEID = $iNVOICEID;
        return $this;
    }
    /**
     * Get PORTAL_DIRECTION value
     * @return string|null
     */
    public function getPORTAL_DIRECTION()
    {
        return $this->PORTAL_DIRECTION;
    }
    /**
     * Set PORTAL_DIRECTION value
     * @param string $pORTAL_DIRECTION
     * @return \StructType\ArchiveInvoiceReadRequest
     */
    public function setPORTAL_DIRECTION($pORTAL_DIRECTION = null)
    {
        // validation for constraint: string
        if (!is_null($pORTAL_DIRECTION) && !is_string($pORTAL_DIRECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pORTAL_DIRECTION)), __LINE__);
        }
        $this->PORTAL_DIRECTION = $pORTAL_DIRECTION;
        return $this;
    }
    /**
     * Get EXTERNAL_ID value
     * @return int|null
     */
    public function getEXTERNAL_ID()
    {
        return $this->EXTERNAL_ID;
    }
    /**
     * Set EXTERNAL_ID value
     * @param int $eXTERNAL_ID
     * @return \StructType\ArchiveInvoiceReadRequest
     */
    public function setEXTERNAL_ID($eXTERNAL_ID = null)
    {
        // validation for constraint: int
        if (!is_null($eXTERNAL_ID) && !is_numeric($eXTERNAL_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eXTERNAL_ID)), __LINE__);
        }
        $this->EXTERNAL_ID = $eXTERNAL_ID;
        return $this;
    }
    /**
     * Get PROFILE value
     * @return string|null
     */
    public function getPROFILE()
    {
        return $this->PROFILE;
    }
    /**
     * Set PROFILE value
     * @param string $pROFILE
     * @return \StructType\ArchiveInvoiceReadRequest
     */
    public function setPROFILE($pROFILE = null)
    {
        // validation for constraint: string
        if (!is_null($pROFILE) && !is_string($pROFILE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pROFILE)), __LINE__);
        }
        $this->PROFILE = $pROFILE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArchiveInvoiceReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
