<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArchiveGetInvoiceInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ArchiveGetInvoiceInfoRequest
 * @subpackage Structs
 */
class ArchiveGetInvoiceInfoRequest extends AbstractStructBase
{
    /**
     * The PAGE_SIZE
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $PAGE_SIZE;
    /**
     * The PAGE_NUMBER
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $PAGE_NUMBER;
    /**
     * The REQUEST_HEADER
     * @var \StructType\REQUEST_HEADERType
     */
    public $REQUEST_HEADER;
    /**
     * Constructor method for ArchiveGetInvoiceInfoRequest
     * @uses ArchiveGetInvoiceInfoRequest::setPAGE_SIZE()
     * @uses ArchiveGetInvoiceInfoRequest::setPAGE_NUMBER()
     * @uses ArchiveGetInvoiceInfoRequest::setREQUEST_HEADER()
     * @param int $pAGE_SIZE
     * @param int $pAGE_NUMBER
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     */
    public function __construct($pAGE_SIZE = null, $pAGE_NUMBER = null, \StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this
            ->setPAGE_SIZE($pAGE_SIZE)
            ->setPAGE_NUMBER($pAGE_NUMBER)
            ->setREQUEST_HEADER($rEQUEST_HEADER);
    }
    /**
     * Get PAGE_SIZE value
     * @return int
     */
    public function getPAGE_SIZE()
    {
        return $this->PAGE_SIZE;
    }
    /**
     * Set PAGE_SIZE value
     * @param int $pAGE_SIZE
     * @return \StructType\ArchiveGetInvoiceInfoRequest
     */
    public function setPAGE_SIZE($pAGE_SIZE = null)
    {
        // validation for constraint: int
        if (!is_null($pAGE_SIZE) && !is_numeric($pAGE_SIZE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pAGE_SIZE)), __LINE__);
        }
        $this->PAGE_SIZE = $pAGE_SIZE;
        return $this;
    }
    /**
     * Get PAGE_NUMBER value
     * @return int
     */
    public function getPAGE_NUMBER()
    {
        return $this->PAGE_NUMBER;
    }
    /**
     * Set PAGE_NUMBER value
     * @param int $pAGE_NUMBER
     * @return \StructType\ArchiveGetInvoiceInfoRequest
     */
    public function setPAGE_NUMBER($pAGE_NUMBER = null)
    {
        // validation for constraint: int
        if (!is_null($pAGE_NUMBER) && !is_numeric($pAGE_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pAGE_NUMBER)), __LINE__);
        }
        $this->PAGE_NUMBER = $pAGE_NUMBER;
        return $this;
    }
    /**
     * Get REQUEST_HEADER value
     * @return \StructType\REQUEST_HEADERType|null
     */
    public function getREQUEST_HEADER()
    {
        return $this->REQUEST_HEADER;
    }
    /**
     * Set REQUEST_HEADER value
     * @param \StructType\REQUEST_HEADERType $rEQUEST_HEADER
     * @return \StructType\ArchiveGetInvoiceInfoRequest
     */
    public function setREQUEST_HEADER(\StructType\REQUEST_HEADERType $rEQUEST_HEADER = null)
    {
        $this->REQUEST_HEADER = $rEQUEST_HEADER;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArchiveGetInvoiceInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
