<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Write ServiceType
 * @subpackage Services
 */
class Write extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WriteToArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArchiveInvoiceWriteRequest $request
     * @return \StructType\ArchiveInvoiceWriteResponse|bool
     */
    public function WriteToArchive(\StructType\ArchiveInvoiceWriteRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->WriteToArchive($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WriteToArchiveExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArchiveInvoiceExtendedRequest $request
     * @return \StructType\ArchiveInvoiceExtendedResponse|bool
     */
    public function WriteToArchiveExtended(\StructType\ArchiveInvoiceExtendedRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->WriteToArchiveExtended($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ArchiveInvoiceExtendedResponse|\StructType\ArchiveInvoiceWriteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
