<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Archive ServiceType
 * @subpackage Services
 */
class Archive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ArchiveGenericDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArchiveGenericDocumentRequest $request
     * @return \StructType\ArchiveGenericDocumentResponse|bool
     */
    public function ArchiveGenericDocument(\StructType\ArchiveGenericDocumentRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->ArchiveGenericDocument($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ArchiveGetInvoiceInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArchiveGetInvoiceInfoRequest $request
     * @return \StructType\ArchiveGetInvoiceInfoResponse|bool
     */
    public function ArchiveGetInvoiceInfo(\StructType\ArchiveGetInvoiceInfoRequest $request)
    {
        try {
            $this->setResult(self::getSoapClient()->ArchiveGetInvoiceInfo($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ArchiveGenericDocumentResponse|\StructType\ArchiveGetInvoiceInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
