<?php

namespace EnumType;

/**
 * This class stands for odemeTipEnum EnumType
 * @subpackage Enumerations
 */
class OdemeTipEnum
{
    /**
     * Constant for value 'KREDIKARTI/BANKAKARTI'
     * @return string 'KREDIKARTI/BANKAKARTI'
     */
    const VALUE_KREDIKARTI_BANKAKARTI = 'KREDIKARTI/BANKAKARTI';
    /**
     * Constant for value 'EFT/HAVALE'
     * @return string 'EFT/HAVALE'
     */
    const VALUE_EFT_HAVALE = 'EFT/HAVALE';
    /**
     * Constant for value 'KAPIDAODEME'
     * @return string 'KAPIDAODEME'
     */
    const VALUE_KAPIDAODEME = 'KAPIDAODEME';
    /**
     * Constant for value 'ODEMEARACISI'
     * @return string 'ODEMEARACISI'
     */
    const VALUE_ODEMEARACISI = 'ODEMEARACISI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KREDIKARTI_BANKAKARTI
     * @uses self::VALUE_EFT_HAVALE
     * @uses self::VALUE_KAPIDAODEME
     * @uses self::VALUE_ODEMEARACISI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KREDIKARTI_BANKAKARTI,
            self::VALUE_EFT_HAVALE,
            self::VALUE_KAPIDAODEME,
            self::VALUE_ODEMEARACISI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
