<?php

namespace EnumType;

/**
 * This class stands for DOC_TYPE EnumType
 * @subpackage Enumerations
 */
class DOC_TYPE
{
    /**
     * Constant for value 'KEBIR DEFTERI'
     * @return string 'KEBIR DEFTERI'
     */
    const VALUE_KEBIR_DEFTERI = 'KEBIR DEFTERI';
    /**
     * Constant for value 'YEVMIYE DEFTERI'
     * @return string 'YEVMIYE DEFTERI'
     */
    const VALUE_YEVMIYE_DEFTERI = 'YEVMIYE DEFTERI';
    /**
     * Constant for value 'KEBIR BERATI'
     * @return string 'KEBIR BERATI'
     */
    const VALUE_KEBIR_BERATI = 'KEBIR BERATI';
    /**
     * Constant for value 'YEVMIYE BERATI'
     * @return string 'YEVMIYE BERATI'
     */
    const VALUE_YEVMIYE_BERATI = 'YEVMIYE BERATI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEBIR_DEFTERI
     * @uses self::VALUE_YEVMIYE_DEFTERI
     * @uses self::VALUE_KEBIR_BERATI
     * @uses self::VALUE_YEVMIYE_BERATI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEBIR_DEFTERI,
            self::VALUE_YEVMIYE_DEFTERI,
            self::VALUE_KEBIR_BERATI,
            self::VALUE_YEVMIYE_BERATI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
