<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAdESTimeStampType StructType
 * @subpackage Structs
 */
class XAdESTimeStampType extends GenericTimeStampType
{
    /**
     * The Include
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: Include
     * @var \StructType\IncludeType[]
     */
    public $Include;
    /**
     * The CanonicalizationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:CanonicalizationMethod
     * @var \StructType\CanonicalizationMethodType
     */
    public $CanonicalizationMethod;
    /**
     * The EncapsulatedTimeStamp
     * @var \StructType\EncapsulatedPKIDataType
     */
    public $EncapsulatedTimeStamp;
    /**
     * The XMLTimeStamp
     * @var \StructType\AnyType
     */
    public $XMLTimeStamp;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for XAdESTimeStampType
     * @uses XAdESTimeStampType::setInclude()
     * @uses XAdESTimeStampType::setCanonicalizationMethod()
     * @uses XAdESTimeStampType::setEncapsulatedTimeStamp()
     * @uses XAdESTimeStampType::setXMLTimeStamp()
     * @uses XAdESTimeStampType::setId()
     * @param \StructType\IncludeType[] $include
     * @param \StructType\CanonicalizationMethodType $canonicalizationMethod
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp
     * @param \StructType\AnyType $xMLTimeStamp
     * @param string $id
     */
    public function __construct(array $include = array(), \StructType\CanonicalizationMethodType $canonicalizationMethod = null, \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp = null, \StructType\AnyType $xMLTimeStamp = null, $id = null)
    {
        $this
            ->setInclude($include)
            ->setCanonicalizationMethod($canonicalizationMethod)
            ->setEncapsulatedTimeStamp($encapsulatedTimeStamp)
            ->setXMLTimeStamp($xMLTimeStamp)
            ->setId($id);
    }
    /**
     * Get Include value
     * @return \StructType\IncludeType[]|null
     */
    public function getInclude()
    {
        return $this->Include;
    }
    /**
     * Set Include value
     * @throws \InvalidArgumentException
     * @param \StructType\IncludeType[] $include
     * @return \StructType\XAdESTimeStampType
     */
    public function setInclude(array $include = array())
    {
        foreach ($include as $xAdESTimeStampTypeIncludeItem) {
            // validation for constraint: itemType
            if (!$xAdESTimeStampTypeIncludeItem instanceof \StructType\IncludeType) {
                throw new \InvalidArgumentException(sprintf('The Include property can only contain items of \StructType\IncludeType, "%s" given', is_object($xAdESTimeStampTypeIncludeItem) ? get_class($xAdESTimeStampTypeIncludeItem) : gettype($xAdESTimeStampTypeIncludeItem)), __LINE__);
            }
        }
        $this->Include = $include;
        return $this;
    }
    /**
     * Add item to Include value
     * @throws \InvalidArgumentException
     * @param \StructType\IncludeType $item
     * @return \StructType\XAdESTimeStampType
     */
    public function addToInclude(\StructType\IncludeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IncludeType) {
            throw new \InvalidArgumentException(sprintf('The Include property can only contain items of \StructType\IncludeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Include[] = $item;
        return $this;
    }
    /**
     * Get CanonicalizationMethod value
     * @return \StructType\CanonicalizationMethodType|null
     */
    public function getCanonicalizationMethod()
    {
        return $this->CanonicalizationMethod;
    }
    /**
     * Set CanonicalizationMethod value
     * @param \StructType\CanonicalizationMethodType $canonicalizationMethod
     * @return \StructType\XAdESTimeStampType
     */
    public function setCanonicalizationMethod(\StructType\CanonicalizationMethodType $canonicalizationMethod = null)
    {
        $this->CanonicalizationMethod = $canonicalizationMethod;
        return $this;
    }
    /**
     * Get EncapsulatedTimeStamp value
     * @return \StructType\EncapsulatedPKIDataType|null
     */
    public function getEncapsulatedTimeStamp()
    {
        return $this->EncapsulatedTimeStamp;
    }
    /**
     * Set EncapsulatedTimeStamp value
     * @param \StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp
     * @return \StructType\XAdESTimeStampType
     */
    public function setEncapsulatedTimeStamp(\StructType\EncapsulatedPKIDataType $encapsulatedTimeStamp = null)
    {
        $this->EncapsulatedTimeStamp = $encapsulatedTimeStamp;
        return $this;
    }
    /**
     * Get XMLTimeStamp value
     * @return \StructType\AnyType|null
     */
    public function getXMLTimeStamp()
    {
        return $this->XMLTimeStamp;
    }
    /**
     * Set XMLTimeStamp value
     * @param \StructType\AnyType $xMLTimeStamp
     * @return \StructType\XAdESTimeStampType
     */
    public function setXMLTimeStamp(\StructType\AnyType $xMLTimeStamp = null)
    {
        $this->XMLTimeStamp = $xMLTimeStamp;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\XAdESTimeStampType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XAdESTimeStampType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
