<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationDataType StructType
 * @subpackage Structs
 */
class ValidationDataType extends AbstractStructBase
{
    /**
     * The CertificateValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: xades:CertificateValues
     * @var \StructType\CertificateValuesType
     */
    public $CertificateValues;
    /**
     * The RevocationValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: xades:RevocationValues
     * @var \StructType\RevocationValuesType
     */
    public $RevocationValues;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The UR
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $UR;
    /**
     * Constructor method for ValidationDataType
     * @uses ValidationDataType::setCertificateValues()
     * @uses ValidationDataType::setRevocationValues()
     * @uses ValidationDataType::setId()
     * @uses ValidationDataType::setUR()
     * @param \StructType\CertificateValuesType $certificateValues
     * @param \StructType\RevocationValuesType $revocationValues
     * @param string $id
     * @param string $uR
     */
    public function __construct(\StructType\CertificateValuesType $certificateValues = null, \StructType\RevocationValuesType $revocationValues = null, $id = null, $uR = null)
    {
        $this
            ->setCertificateValues($certificateValues)
            ->setRevocationValues($revocationValues)
            ->setId($id)
            ->setUR($uR);
    }
    /**
     * Get CertificateValues value
     * @return \StructType\CertificateValuesType|null
     */
    public function getCertificateValues()
    {
        return $this->CertificateValues;
    }
    /**
     * Set CertificateValues value
     * @param \StructType\CertificateValuesType $certificateValues
     * @return \StructType\ValidationDataType
     */
    public function setCertificateValues(\StructType\CertificateValuesType $certificateValues = null)
    {
        $this->CertificateValues = $certificateValues;
        return $this;
    }
    /**
     * Get RevocationValues value
     * @return \StructType\RevocationValuesType|null
     */
    public function getRevocationValues()
    {
        return $this->RevocationValues;
    }
    /**
     * Set RevocationValues value
     * @param \StructType\RevocationValuesType $revocationValues
     * @return \StructType\ValidationDataType
     */
    public function setRevocationValues(\StructType\RevocationValuesType $revocationValues = null)
    {
        $this->RevocationValues = $revocationValues;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ValidationDataType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get UR value
     * @return string|null
     */
    public function getUR()
    {
        return $this->UR;
    }
    /**
     * Set UR value
     * @param string $uR
     * @return \StructType\ValidationDataType
     */
    public function setUR($uR = null)
    {
        // validation for constraint: string
        if (!is_null($uR) && !is_string($uR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uR)), __LINE__);
        }
        $this->UR = $uR;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidationDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
