<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnsignedSignaturePropertiesType StructType
 * @subpackage Structs
 */
class UnsignedSignaturePropertiesType extends AbstractStructBase
{
    /**
     * The CounterSignature
     * @var \StructType\CounterSignatureType
     */
    public $CounterSignature;
    /**
     * The SignatureTimeStamp
     * @var \StructType\XAdESTimeStampType
     */
    public $SignatureTimeStamp;
    /**
     * The CompleteCertificateRefs
     * @var \StructType\CompleteCertificateRefsType
     */
    public $CompleteCertificateRefs;
    /**
     * The CompleteRevocationRefs
     * @var \StructType\CompleteRevocationRefsType
     */
    public $CompleteRevocationRefs;
    /**
     * The AttributeCertificateRefs
     * @var \StructType\CompleteCertificateRefsType
     */
    public $AttributeCertificateRefs;
    /**
     * The AttributeRevocationRefs
     * @var \StructType\CompleteRevocationRefsType
     */
    public $AttributeRevocationRefs;
    /**
     * The SigAndRefsTimeStamp
     * @var \StructType\XAdESTimeStampType
     */
    public $SigAndRefsTimeStamp;
    /**
     * The RefsOnlyTimeStamp
     * @var \StructType\XAdESTimeStampType
     */
    public $RefsOnlyTimeStamp;
    /**
     * The CertificateValues
     * @var \StructType\CertificateValuesType
     */
    public $CertificateValues;
    /**
     * The RevocationValues
     * @var \StructType\RevocationValuesType
     */
    public $RevocationValues;
    /**
     * The AttrAuthoritiesCertValues
     * @var \StructType\CertificateValuesType
     */
    public $AttrAuthoritiesCertValues;
    /**
     * The AttributeRevocationValues
     * @var \StructType\RevocationValuesType
     */
    public $AttributeRevocationValues;
    /**
     * The ArchiveTimeStamp
     * @var \StructType\XAdESTimeStampType
     */
    public $ArchiveTimeStamp;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for UnsignedSignaturePropertiesType
     * @uses UnsignedSignaturePropertiesType::setCounterSignature()
     * @uses UnsignedSignaturePropertiesType::setSignatureTimeStamp()
     * @uses UnsignedSignaturePropertiesType::setCompleteCertificateRefs()
     * @uses UnsignedSignaturePropertiesType::setCompleteRevocationRefs()
     * @uses UnsignedSignaturePropertiesType::setAttributeCertificateRefs()
     * @uses UnsignedSignaturePropertiesType::setAttributeRevocationRefs()
     * @uses UnsignedSignaturePropertiesType::setSigAndRefsTimeStamp()
     * @uses UnsignedSignaturePropertiesType::setRefsOnlyTimeStamp()
     * @uses UnsignedSignaturePropertiesType::setCertificateValues()
     * @uses UnsignedSignaturePropertiesType::setRevocationValues()
     * @uses UnsignedSignaturePropertiesType::setAttrAuthoritiesCertValues()
     * @uses UnsignedSignaturePropertiesType::setAttributeRevocationValues()
     * @uses UnsignedSignaturePropertiesType::setArchiveTimeStamp()
     * @uses UnsignedSignaturePropertiesType::setAny()
     * @uses UnsignedSignaturePropertiesType::setId()
     * @param \StructType\CounterSignatureType $counterSignature
     * @param \StructType\XAdESTimeStampType $signatureTimeStamp
     * @param \StructType\CompleteCertificateRefsType $completeCertificateRefs
     * @param \StructType\CompleteRevocationRefsType $completeRevocationRefs
     * @param \StructType\CompleteCertificateRefsType $attributeCertificateRefs
     * @param \StructType\CompleteRevocationRefsType $attributeRevocationRefs
     * @param \StructType\XAdESTimeStampType $sigAndRefsTimeStamp
     * @param \StructType\XAdESTimeStampType $refsOnlyTimeStamp
     * @param \StructType\CertificateValuesType $certificateValues
     * @param \StructType\RevocationValuesType $revocationValues
     * @param \StructType\CertificateValuesType $attrAuthoritiesCertValues
     * @param \StructType\RevocationValuesType $attributeRevocationValues
     * @param \StructType\XAdESTimeStampType $archiveTimeStamp
     * @param \DOMDocument $any
     * @param string $id
     */
    public function __construct(\StructType\CounterSignatureType $counterSignature = null, \StructType\XAdESTimeStampType $signatureTimeStamp = null, \StructType\CompleteCertificateRefsType $completeCertificateRefs = null, \StructType\CompleteRevocationRefsType $completeRevocationRefs = null, \StructType\CompleteCertificateRefsType $attributeCertificateRefs = null, \StructType\CompleteRevocationRefsType $attributeRevocationRefs = null, \StructType\XAdESTimeStampType $sigAndRefsTimeStamp = null, \StructType\XAdESTimeStampType $refsOnlyTimeStamp = null, \StructType\CertificateValuesType $certificateValues = null, \StructType\RevocationValuesType $revocationValues = null, \StructType\CertificateValuesType $attrAuthoritiesCertValues = null, \StructType\RevocationValuesType $attributeRevocationValues = null, \StructType\XAdESTimeStampType $archiveTimeStamp = null, \DOMDocument $any = null, $id = null)
    {
        $this
            ->setCounterSignature($counterSignature)
            ->setSignatureTimeStamp($signatureTimeStamp)
            ->setCompleteCertificateRefs($completeCertificateRefs)
            ->setCompleteRevocationRefs($completeRevocationRefs)
            ->setAttributeCertificateRefs($attributeCertificateRefs)
            ->setAttributeRevocationRefs($attributeRevocationRefs)
            ->setSigAndRefsTimeStamp($sigAndRefsTimeStamp)
            ->setRefsOnlyTimeStamp($refsOnlyTimeStamp)
            ->setCertificateValues($certificateValues)
            ->setRevocationValues($revocationValues)
            ->setAttrAuthoritiesCertValues($attrAuthoritiesCertValues)
            ->setAttributeRevocationValues($attributeRevocationValues)
            ->setArchiveTimeStamp($archiveTimeStamp)
            ->setAny($any)
            ->setId($id);
    }
    /**
     * Get CounterSignature value
     * @return \StructType\CounterSignatureType|null
     */
    public function getCounterSignature()
    {
        return $this->CounterSignature;
    }
    /**
     * Set CounterSignature value
     * @param \StructType\CounterSignatureType $counterSignature
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setCounterSignature(\StructType\CounterSignatureType $counterSignature = null)
    {
        $this->CounterSignature = $counterSignature;
        return $this;
    }
    /**
     * Get SignatureTimeStamp value
     * @return \StructType\XAdESTimeStampType|null
     */
    public function getSignatureTimeStamp()
    {
        return $this->SignatureTimeStamp;
    }
    /**
     * Set SignatureTimeStamp value
     * @param \StructType\XAdESTimeStampType $signatureTimeStamp
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setSignatureTimeStamp(\StructType\XAdESTimeStampType $signatureTimeStamp = null)
    {
        $this->SignatureTimeStamp = $signatureTimeStamp;
        return $this;
    }
    /**
     * Get CompleteCertificateRefs value
     * @return \StructType\CompleteCertificateRefsType|null
     */
    public function getCompleteCertificateRefs()
    {
        return $this->CompleteCertificateRefs;
    }
    /**
     * Set CompleteCertificateRefs value
     * @param \StructType\CompleteCertificateRefsType $completeCertificateRefs
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setCompleteCertificateRefs(\StructType\CompleteCertificateRefsType $completeCertificateRefs = null)
    {
        $this->CompleteCertificateRefs = $completeCertificateRefs;
        return $this;
    }
    /**
     * Get CompleteRevocationRefs value
     * @return \StructType\CompleteRevocationRefsType|null
     */
    public function getCompleteRevocationRefs()
    {
        return $this->CompleteRevocationRefs;
    }
    /**
     * Set CompleteRevocationRefs value
     * @param \StructType\CompleteRevocationRefsType $completeRevocationRefs
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setCompleteRevocationRefs(\StructType\CompleteRevocationRefsType $completeRevocationRefs = null)
    {
        $this->CompleteRevocationRefs = $completeRevocationRefs;
        return $this;
    }
    /**
     * Get AttributeCertificateRefs value
     * @return \StructType\CompleteCertificateRefsType|null
     */
    public function getAttributeCertificateRefs()
    {
        return $this->AttributeCertificateRefs;
    }
    /**
     * Set AttributeCertificateRefs value
     * @param \StructType\CompleteCertificateRefsType $attributeCertificateRefs
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setAttributeCertificateRefs(\StructType\CompleteCertificateRefsType $attributeCertificateRefs = null)
    {
        $this->AttributeCertificateRefs = $attributeCertificateRefs;
        return $this;
    }
    /**
     * Get AttributeRevocationRefs value
     * @return \StructType\CompleteRevocationRefsType|null
     */
    public function getAttributeRevocationRefs()
    {
        return $this->AttributeRevocationRefs;
    }
    /**
     * Set AttributeRevocationRefs value
     * @param \StructType\CompleteRevocationRefsType $attributeRevocationRefs
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setAttributeRevocationRefs(\StructType\CompleteRevocationRefsType $attributeRevocationRefs = null)
    {
        $this->AttributeRevocationRefs = $attributeRevocationRefs;
        return $this;
    }
    /**
     * Get SigAndRefsTimeStamp value
     * @return \StructType\XAdESTimeStampType|null
     */
    public function getSigAndRefsTimeStamp()
    {
        return $this->SigAndRefsTimeStamp;
    }
    /**
     * Set SigAndRefsTimeStamp value
     * @param \StructType\XAdESTimeStampType $sigAndRefsTimeStamp
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setSigAndRefsTimeStamp(\StructType\XAdESTimeStampType $sigAndRefsTimeStamp = null)
    {
        $this->SigAndRefsTimeStamp = $sigAndRefsTimeStamp;
        return $this;
    }
    /**
     * Get RefsOnlyTimeStamp value
     * @return \StructType\XAdESTimeStampType|null
     */
    public function getRefsOnlyTimeStamp()
    {
        return $this->RefsOnlyTimeStamp;
    }
    /**
     * Set RefsOnlyTimeStamp value
     * @param \StructType\XAdESTimeStampType $refsOnlyTimeStamp
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setRefsOnlyTimeStamp(\StructType\XAdESTimeStampType $refsOnlyTimeStamp = null)
    {
        $this->RefsOnlyTimeStamp = $refsOnlyTimeStamp;
        return $this;
    }
    /**
     * Get CertificateValues value
     * @return \StructType\CertificateValuesType|null
     */
    public function getCertificateValues()
    {
        return $this->CertificateValues;
    }
    /**
     * Set CertificateValues value
     * @param \StructType\CertificateValuesType $certificateValues
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setCertificateValues(\StructType\CertificateValuesType $certificateValues = null)
    {
        $this->CertificateValues = $certificateValues;
        return $this;
    }
    /**
     * Get RevocationValues value
     * @return \StructType\RevocationValuesType|null
     */
    public function getRevocationValues()
    {
        return $this->RevocationValues;
    }
    /**
     * Set RevocationValues value
     * @param \StructType\RevocationValuesType $revocationValues
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setRevocationValues(\StructType\RevocationValuesType $revocationValues = null)
    {
        $this->RevocationValues = $revocationValues;
        return $this;
    }
    /**
     * Get AttrAuthoritiesCertValues value
     * @return \StructType\CertificateValuesType|null
     */
    public function getAttrAuthoritiesCertValues()
    {
        return $this->AttrAuthoritiesCertValues;
    }
    /**
     * Set AttrAuthoritiesCertValues value
     * @param \StructType\CertificateValuesType $attrAuthoritiesCertValues
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setAttrAuthoritiesCertValues(\StructType\CertificateValuesType $attrAuthoritiesCertValues = null)
    {
        $this->AttrAuthoritiesCertValues = $attrAuthoritiesCertValues;
        return $this;
    }
    /**
     * Get AttributeRevocationValues value
     * @return \StructType\RevocationValuesType|null
     */
    public function getAttributeRevocationValues()
    {
        return $this->AttributeRevocationValues;
    }
    /**
     * Set AttributeRevocationValues value
     * @param \StructType\RevocationValuesType $attributeRevocationValues
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setAttributeRevocationValues(\StructType\RevocationValuesType $attributeRevocationValues = null)
    {
        $this->AttributeRevocationValues = $attributeRevocationValues;
        return $this;
    }
    /**
     * Get ArchiveTimeStamp value
     * @return \StructType\XAdESTimeStampType|null
     */
    public function getArchiveTimeStamp()
    {
        return $this->ArchiveTimeStamp;
    }
    /**
     * Set ArchiveTimeStamp value
     * @param \StructType\XAdESTimeStampType $archiveTimeStamp
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setArchiveTimeStamp(\StructType\XAdESTimeStampType $archiveTimeStamp = null)
    {
        $this->ArchiveTimeStamp = $archiveTimeStamp;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\UnsignedSignaturePropertiesType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnsignedSignaturePropertiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
