<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnsignedDataObjectPropertiesType StructType
 * @subpackage Structs
 */
class UnsignedDataObjectPropertiesType extends AbstractStructBase
{
    /**
     * The UnsignedDataObjectProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AnyType[]
     */
    public $UnsignedDataObjectProperty;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for UnsignedDataObjectPropertiesType
     * @uses UnsignedDataObjectPropertiesType::setUnsignedDataObjectProperty()
     * @uses UnsignedDataObjectPropertiesType::setId()
     * @param \StructType\AnyType[] $unsignedDataObjectProperty
     * @param string $id
     */
    public function __construct(array $unsignedDataObjectProperty = array(), $id = null)
    {
        $this
            ->setUnsignedDataObjectProperty($unsignedDataObjectProperty)
            ->setId($id);
    }
    /**
     * Get UnsignedDataObjectProperty value
     * @return \StructType\AnyType[]|null
     */
    public function getUnsignedDataObjectProperty()
    {
        return $this->UnsignedDataObjectProperty;
    }
    /**
     * Set UnsignedDataObjectProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\AnyType[] $unsignedDataObjectProperty
     * @return \StructType\UnsignedDataObjectPropertiesType
     */
    public function setUnsignedDataObjectProperty(array $unsignedDataObjectProperty = array())
    {
        foreach ($unsignedDataObjectProperty as $unsignedDataObjectPropertiesTypeUnsignedDataObjectPropertyItem) {
            // validation for constraint: itemType
            if (!$unsignedDataObjectPropertiesTypeUnsignedDataObjectPropertyItem instanceof \StructType\AnyType) {
                throw new \InvalidArgumentException(sprintf('The UnsignedDataObjectProperty property can only contain items of \StructType\AnyType, "%s" given', is_object($unsignedDataObjectPropertiesTypeUnsignedDataObjectPropertyItem) ? get_class($unsignedDataObjectPropertiesTypeUnsignedDataObjectPropertyItem) : gettype($unsignedDataObjectPropertiesTypeUnsignedDataObjectPropertyItem)), __LINE__);
            }
        }
        $this->UnsignedDataObjectProperty = $unsignedDataObjectProperty;
        return $this;
    }
    /**
     * Add item to UnsignedDataObjectProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\AnyType $item
     * @return \StructType\UnsignedDataObjectPropertiesType
     */
    public function addToUnsignedDataObjectProperty(\StructType\AnyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnyType) {
            throw new \InvalidArgumentException(sprintf('The UnsignedDataObjectProperty property can only contain items of \StructType\AnyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnsignedDataObjectProperty[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\UnsignedDataObjectPropertiesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnsignedDataObjectPropertiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
