<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SEARCH_KEYType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Base type used for search keys
 * @subpackage Structs
 */
class SEARCH_KEYType extends AbstractStructBase
{
    /**
     * The VALID_FROM
     * Meta informations extracted from the WSDL
     * - documentation: Valid From
     * - minOccurs: 0
     * @var string
     */
    public $VALID_FROM;
    /**
     * The VALID_TO
     * Meta informations extracted from the WSDL
     * - documentation: Valid To
     * - minOccurs: 0
     * @var string
     */
    public $VALID_TO;
    /**
     * The ROWNUM_OFFSET
     * Meta informations extracted from the WSDL
     * - documentation: For searches that may return many rows, this parameters specifies the starting rownum of query to be returned by BACKEND system
     * - minOccurs: 0
     * @var int
     */
    public $ROWNUM_OFFSET;
    /**
     * The ROWNUM_LIMIT
     * Meta informations extracted from the WSDL
     * - documentation: For searches that may return many rows, this parameters specifies the maximum rownums to be returned starting with ROWNUM_OFFSET
     * - minOccurs: 0
     * @var int
     */
    public $ROWNUM_LIMIT;
    /**
     * Constructor method for SEARCH_KEYType
     * @uses SEARCH_KEYType::setVALID_FROM()
     * @uses SEARCH_KEYType::setVALID_TO()
     * @uses SEARCH_KEYType::setROWNUM_OFFSET()
     * @uses SEARCH_KEYType::setROWNUM_LIMIT()
     * @param string $vALID_FROM
     * @param string $vALID_TO
     * @param int $rOWNUM_OFFSET
     * @param int $rOWNUM_LIMIT
     */
    public function __construct($vALID_FROM = null, $vALID_TO = null, $rOWNUM_OFFSET = null, $rOWNUM_LIMIT = null)
    {
        $this
            ->setVALID_FROM($vALID_FROM)
            ->setVALID_TO($vALID_TO)
            ->setROWNUM_OFFSET($rOWNUM_OFFSET)
            ->setROWNUM_LIMIT($rOWNUM_LIMIT);
    }
    /**
     * Get VALID_FROM value
     * @return string|null
     */
    public function getVALID_FROM()
    {
        return $this->VALID_FROM;
    }
    /**
     * Set VALID_FROM value
     * @param string $vALID_FROM
     * @return \StructType\SEARCH_KEYType
     */
    public function setVALID_FROM($vALID_FROM = null)
    {
        // validation for constraint: string
        if (!is_null($vALID_FROM) && !is_string($vALID_FROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vALID_FROM)), __LINE__);
        }
        $this->VALID_FROM = $vALID_FROM;
        return $this;
    }
    /**
     * Get VALID_TO value
     * @return string|null
     */
    public function getVALID_TO()
    {
        return $this->VALID_TO;
    }
    /**
     * Set VALID_TO value
     * @param string $vALID_TO
     * @return \StructType\SEARCH_KEYType
     */
    public function setVALID_TO($vALID_TO = null)
    {
        // validation for constraint: string
        if (!is_null($vALID_TO) && !is_string($vALID_TO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vALID_TO)), __LINE__);
        }
        $this->VALID_TO = $vALID_TO;
        return $this;
    }
    /**
     * Get ROWNUM_OFFSET value
     * @return int|null
     */
    public function getROWNUM_OFFSET()
    {
        return $this->ROWNUM_OFFSET;
    }
    /**
     * Set ROWNUM_OFFSET value
     * @param int $rOWNUM_OFFSET
     * @return \StructType\SEARCH_KEYType
     */
    public function setROWNUM_OFFSET($rOWNUM_OFFSET = null)
    {
        // validation for constraint: int
        if (!is_null($rOWNUM_OFFSET) && !is_numeric($rOWNUM_OFFSET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rOWNUM_OFFSET)), __LINE__);
        }
        $this->ROWNUM_OFFSET = $rOWNUM_OFFSET;
        return $this;
    }
    /**
     * Get ROWNUM_LIMIT value
     * @return int|null
     */
    public function getROWNUM_LIMIT()
    {
        return $this->ROWNUM_LIMIT;
    }
    /**
     * Set ROWNUM_LIMIT value
     * @param int $rOWNUM_LIMIT
     * @return \StructType\SEARCH_KEYType
     */
    public function setROWNUM_LIMIT($rOWNUM_LIMIT = null)
    {
        // validation for constraint: int
        if (!is_null($rOWNUM_LIMIT) && !is_numeric($rOWNUM_LIMIT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rOWNUM_LIMIT)), __LINE__);
        }
        $this->ROWNUM_LIMIT = $rOWNUM_LIMIT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SEARCH_KEYType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
