<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for REQUEST_RETURNType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Request response related context information including data such as RETURN_CODE, DETAILED_RESULT information etc.
 * @subpackage Structs
 */
class REQUEST_RETURNType extends AbstractStructBase
{
    /**
     * The INTL_TXN_ID
     * Meta informations extracted from the WSDL
     * - documentation: Internal TXN ID
     * @var int
     */
    public $INTL_TXN_ID;
    /**
     * The CLIENT_TXN_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Initiating domain Transaction ID of the action | Initiating domain Transaction ID of the action
     * - maxLength: 64
     * @var string
     */
    public $CLIENT_TXN_ID;
    /**
     * The RETURN_CODE
     * Meta informations extracted from the WSDL
     * - documentation: Numeric return code of the action. 0: success, negative: failure, positive: success with warning
     * @var int
     */
    public $RETURN_CODE;
    /**
     * The WARNINGS
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $WARNINGS;
    /**
     * Constructor method for REQUEST_RETURNType
     * @uses REQUEST_RETURNType::setINTL_TXN_ID()
     * @uses REQUEST_RETURNType::setCLIENT_TXN_ID()
     * @uses REQUEST_RETURNType::setRETURN_CODE()
     * @uses REQUEST_RETURNType::setWARNINGS()
     * @param int $iNTL_TXN_ID
     * @param string $cLIENT_TXN_ID
     * @param int $rETURN_CODE
     * @param string[] $wARNINGS
     */
    public function __construct($iNTL_TXN_ID = null, $cLIENT_TXN_ID = null, $rETURN_CODE = null, array $wARNINGS = array())
    {
        $this
            ->setINTL_TXN_ID($iNTL_TXN_ID)
            ->setCLIENT_TXN_ID($cLIENT_TXN_ID)
            ->setRETURN_CODE($rETURN_CODE)
            ->setWARNINGS($wARNINGS);
    }
    /**
     * Get INTL_TXN_ID value
     * @return int|null
     */
    public function getINTL_TXN_ID()
    {
        return $this->INTL_TXN_ID;
    }
    /**
     * Set INTL_TXN_ID value
     * @param int $iNTL_TXN_ID
     * @return \StructType\REQUEST_RETURNType
     */
    public function setINTL_TXN_ID($iNTL_TXN_ID = null)
    {
        // validation for constraint: int
        if (!is_null($iNTL_TXN_ID) && !is_numeric($iNTL_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iNTL_TXN_ID)), __LINE__);
        }
        $this->INTL_TXN_ID = $iNTL_TXN_ID;
        return $this;
    }
    /**
     * Get CLIENT_TXN_ID value
     * @return string|null
     */
    public function getCLIENT_TXN_ID()
    {
        return $this->CLIENT_TXN_ID;
    }
    /**
     * Set CLIENT_TXN_ID value
     * @param string $cLIENT_TXN_ID
     * @return \StructType\REQUEST_RETURNType
     */
    public function setCLIENT_TXN_ID($cLIENT_TXN_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cLIENT_TXN_ID) && strlen($cLIENT_TXN_ID) > 64) || (is_array($cLIENT_TXN_ID) && count($cLIENT_TXN_ID) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($cLIENT_TXN_ID) ? strlen($cLIENT_TXN_ID) : count($cLIENT_TXN_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cLIENT_TXN_ID) && !is_string($cLIENT_TXN_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLIENT_TXN_ID)), __LINE__);
        }
        $this->CLIENT_TXN_ID = $cLIENT_TXN_ID;
        return $this;
    }
    /**
     * Get RETURN_CODE value
     * @return int|null
     */
    public function getRETURN_CODE()
    {
        return $this->RETURN_CODE;
    }
    /**
     * Set RETURN_CODE value
     * @param int $rETURN_CODE
     * @return \StructType\REQUEST_RETURNType
     */
    public function setRETURN_CODE($rETURN_CODE = null)
    {
        // validation for constraint: int
        if (!is_null($rETURN_CODE) && !is_numeric($rETURN_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rETURN_CODE)), __LINE__);
        }
        $this->RETURN_CODE = $rETURN_CODE;
        return $this;
    }
    /**
     * Get WARNINGS value
     * @return string[]|null
     */
    public function getWARNINGS()
    {
        return $this->WARNINGS;
    }
    /**
     * Set WARNINGS value
     * @throws \InvalidArgumentException
     * @param string[] $wARNINGS
     * @return \StructType\REQUEST_RETURNType
     */
    public function setWARNINGS(array $wARNINGS = array())
    {
        foreach ($wARNINGS as $rEQUEST_RETURNTypeWARNINGSItem) {
            // validation for constraint: itemType
            if (!is_string($rEQUEST_RETURNTypeWARNINGSItem)) {
                throw new \InvalidArgumentException(sprintf('The WARNINGS property can only contain items of string, "%s" given', is_object($rEQUEST_RETURNTypeWARNINGSItem) ? get_class($rEQUEST_RETURNTypeWARNINGSItem) : gettype($rEQUEST_RETURNTypeWARNINGSItem)), __LINE__);
            }
        }
        $this->WARNINGS = $wARNINGS;
        return $this;
    }
    /**
     * Add item to WARNINGS value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\REQUEST_RETURNType
     */
    public function addToWARNINGS($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The WARNINGS property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WARNINGS[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\REQUEST_RETURNType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
