<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QualifyingPropertiesType StructType
 * @subpackage Structs
 */
class QualifyingPropertiesType extends AbstractStructBase
{
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Target;
    /**
     * The SignedProperties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignedPropertiesType
     */
    public $SignedProperties;
    /**
     * The UnsignedProperties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UnsignedPropertiesType
     */
    public $UnsignedProperties;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for QualifyingPropertiesType
     * @uses QualifyingPropertiesType::setTarget()
     * @uses QualifyingPropertiesType::setSignedProperties()
     * @uses QualifyingPropertiesType::setUnsignedProperties()
     * @uses QualifyingPropertiesType::setId()
     * @param string $target
     * @param \StructType\SignedPropertiesType $signedProperties
     * @param \StructType\UnsignedPropertiesType $unsignedProperties
     * @param string $id
     */
    public function __construct($target = null, \StructType\SignedPropertiesType $signedProperties = null, \StructType\UnsignedPropertiesType $unsignedProperties = null, $id = null)
    {
        $this
            ->setTarget($target)
            ->setSignedProperties($signedProperties)
            ->setUnsignedProperties($unsignedProperties)
            ->setId($id);
    }
    /**
     * Get Target value
     * @return string
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\QualifyingPropertiesType
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get SignedProperties value
     * @return \StructType\SignedPropertiesType|null
     */
    public function getSignedProperties()
    {
        return $this->SignedProperties;
    }
    /**
     * Set SignedProperties value
     * @param \StructType\SignedPropertiesType $signedProperties
     * @return \StructType\QualifyingPropertiesType
     */
    public function setSignedProperties(\StructType\SignedPropertiesType $signedProperties = null)
    {
        $this->SignedProperties = $signedProperties;
        return $this;
    }
    /**
     * Get UnsignedProperties value
     * @return \StructType\UnsignedPropertiesType|null
     */
    public function getUnsignedProperties()
    {
        return $this->UnsignedProperties;
    }
    /**
     * Set UnsignedProperties value
     * @param \StructType\UnsignedPropertiesType $unsignedProperties
     * @return \StructType\QualifyingPropertiesType
     */
    public function setUnsignedProperties(\StructType\UnsignedPropertiesType $unsignedProperties = null)
    {
        $this->UnsignedProperties = $unsignedProperties;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\QualifyingPropertiesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QualifyingPropertiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
