<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MARK StructType
 * @subpackage Structs
 */
class MARK extends AbstractStructBase
{
    /**
     * The EARCHIVE_INVOICE
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\EARCHIVEINV[]
     */
    public $EARCHIVE_INVOICE;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for MARK
     * @uses MARK::setEARCHIVE_INVOICE()
     * @uses MARK::setValue()
     * @param \StructType\EARCHIVEINV[] $eARCHIVE_INVOICE
     * @param string $value
     */
    public function __construct(array $eARCHIVE_INVOICE = array(), $value = null)
    {
        $this
            ->setEARCHIVE_INVOICE($eARCHIVE_INVOICE)
            ->setValue($value);
    }
    /**
     * Get EARCHIVE_INVOICE value
     * @return \StructType\EARCHIVEINV[]
     */
    public function getEARCHIVE_INVOICE()
    {
        return $this->EARCHIVE_INVOICE;
    }
    /**
     * Set EARCHIVE_INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\EARCHIVEINV[] $eARCHIVE_INVOICE
     * @return \StructType\MARK
     */
    public function setEARCHIVE_INVOICE(array $eARCHIVE_INVOICE = array())
    {
        foreach ($eARCHIVE_INVOICE as $mARKEARCHIVE_INVOICEItem) {
            // validation for constraint: itemType
            if (!$mARKEARCHIVE_INVOICEItem instanceof \StructType\EARCHIVEINV) {
                throw new \InvalidArgumentException(sprintf('The EARCHIVE_INVOICE property can only contain items of \StructType\EARCHIVEINV, "%s" given', is_object($mARKEARCHIVE_INVOICEItem) ? get_class($mARKEARCHIVE_INVOICEItem) : gettype($mARKEARCHIVE_INVOICEItem)), __LINE__);
            }
        }
        $this->EARCHIVE_INVOICE = $eARCHIVE_INVOICE;
        return $this;
    }
    /**
     * Add item to EARCHIVE_INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\EARCHIVEINV $item
     * @return \StructType\MARK
     */
    public function addToEARCHIVE_INVOICE(\StructType\EARCHIVEINV $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EARCHIVEINV) {
            throw new \InvalidArgumentException(sprintf('The EARCHIVE_INVOICE property can only contain items of \StructType\EARCHIVEINV, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EARCHIVE_INVOICE[] = $item;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\MARK
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MARK
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
