<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICE_PROPERTIES StructType
 * @subpackage Structs
 */
class INVOICE_PROPERTIES extends AbstractStructBase
{
    /**
     * The EARSIV_FLAG
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 1
     * @var string
     */
    public $EARSIV_FLAG;
    /**
     * The EARSIV_PROPERTIES
     * @var \StructType\EARSIV_PROPERTIES
     */
    public $EARSIV_PROPERTIES;
    /**
     * The PDF_PROPERTIES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PDF_PROPERTIES
     */
    public $PDF_PROPERTIES;
    /**
     * The ARCHIVE_NOTE
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ARCHIVE_NOTE;
    /**
     * The INVOICE_CONTENT
     * @var \StructType\Base64Binary
     */
    public $INVOICE_CONTENT;
    /**
     * Constructor method for INVOICE_PROPERTIES
     * @uses INVOICE_PROPERTIES::setEARSIV_FLAG()
     * @uses INVOICE_PROPERTIES::setEARSIV_PROPERTIES()
     * @uses INVOICE_PROPERTIES::setPDF_PROPERTIES()
     * @uses INVOICE_PROPERTIES::setARCHIVE_NOTE()
     * @uses INVOICE_PROPERTIES::setINVOICE_CONTENT()
     * @param string $eARSIV_FLAG
     * @param \StructType\EARSIV_PROPERTIES $eARSIV_PROPERTIES
     * @param \StructType\PDF_PROPERTIES $pDF_PROPERTIES
     * @param string $aRCHIVE_NOTE
     * @param \StructType\Base64Binary $iNVOICE_CONTENT
     */
    public function __construct($eARSIV_FLAG = 'N', \StructType\EARSIV_PROPERTIES $eARSIV_PROPERTIES = null, \StructType\PDF_PROPERTIES $pDF_PROPERTIES = null, $aRCHIVE_NOTE = null, \StructType\Base64Binary $iNVOICE_CONTENT = null)
    {
        $this
            ->setEARSIV_FLAG($eARSIV_FLAG)
            ->setEARSIV_PROPERTIES($eARSIV_PROPERTIES)
            ->setPDF_PROPERTIES($pDF_PROPERTIES)
            ->setARCHIVE_NOTE($aRCHIVE_NOTE)
            ->setINVOICE_CONTENT($iNVOICE_CONTENT);
    }
    /**
     * Get EARSIV_FLAG value
     * @return string
     */
    public function getEARSIV_FLAG()
    {
        return $this->EARSIV_FLAG;
    }
    /**
     * Set EARSIV_FLAG value
     * @uses \EnumType\FLAG_VALUE::valueIsValid()
     * @uses \EnumType\FLAG_VALUE::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eARSIV_FLAG
     * @return \StructType\INVOICE_PROPERTIES
     */
    public function setEARSIV_FLAG($eARSIV_FLAG = 'N')
    {
        // validation for constraint: enumeration
        if (!\EnumType\FLAG_VALUE::valueIsValid($eARSIV_FLAG)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eARSIV_FLAG, implode(', ', \EnumType\FLAG_VALUE::getValidValues())), __LINE__);
        }
        $this->EARSIV_FLAG = $eARSIV_FLAG;
        return $this;
    }
    /**
     * Get EARSIV_PROPERTIES value
     * @return \StructType\EARSIV_PROPERTIES|null
     */
    public function getEARSIV_PROPERTIES()
    {
        return $this->EARSIV_PROPERTIES;
    }
    /**
     * Set EARSIV_PROPERTIES value
     * @param \StructType\EARSIV_PROPERTIES $eARSIV_PROPERTIES
     * @return \StructType\INVOICE_PROPERTIES
     */
    public function setEARSIV_PROPERTIES(\StructType\EARSIV_PROPERTIES $eARSIV_PROPERTIES = null)
    {
        $this->EARSIV_PROPERTIES = $eARSIV_PROPERTIES;
        return $this;
    }
    /**
     * Get PDF_PROPERTIES value
     * @return \StructType\PDF_PROPERTIES|null
     */
    public function getPDF_PROPERTIES()
    {
        return $this->PDF_PROPERTIES;
    }
    /**
     * Set PDF_PROPERTIES value
     * @param \StructType\PDF_PROPERTIES $pDF_PROPERTIES
     * @return \StructType\INVOICE_PROPERTIES
     */
    public function setPDF_PROPERTIES(\StructType\PDF_PROPERTIES $pDF_PROPERTIES = null)
    {
        $this->PDF_PROPERTIES = $pDF_PROPERTIES;
        return $this;
    }
    /**
     * Get ARCHIVE_NOTE value
     * @return string|null
     */
    public function getARCHIVE_NOTE()
    {
        return $this->ARCHIVE_NOTE;
    }
    /**
     * Set ARCHIVE_NOTE value
     * @param string $aRCHIVE_NOTE
     * @return \StructType\INVOICE_PROPERTIES
     */
    public function setARCHIVE_NOTE($aRCHIVE_NOTE = null)
    {
        // validation for constraint: string
        if (!is_null($aRCHIVE_NOTE) && !is_string($aRCHIVE_NOTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aRCHIVE_NOTE)), __LINE__);
        }
        $this->ARCHIVE_NOTE = $aRCHIVE_NOTE;
        return $this;
    }
    /**
     * Get INVOICE_CONTENT value
     * @return \StructType\Base64Binary|null
     */
    public function getINVOICE_CONTENT()
    {
        return $this->INVOICE_CONTENT;
    }
    /**
     * Set INVOICE_CONTENT value
     * @param \StructType\Base64Binary $iNVOICE_CONTENT
     * @return \StructType\INVOICE_PROPERTIES
     */
    public function setINVOICE_CONTENT(\StructType\Base64Binary $iNVOICE_CONTENT = null)
    {
        $this->INVOICE_CONTENT = $iNVOICE_CONTENT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\INVOICE_PROPERTIES
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
